/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.RRSet;
import java.beans.ConstructorProperties;

public class GetRRSetResponse {
    private String opcNextPage;
    private Integer opcTotalItems;
    private String opcRequestId;
    private String eTag;
    private RRSet rRSet;

    @ConstructorProperties(value={"opcNextPage", "opcTotalItems", "opcRequestId", "eTag", "rRSet"})
    GetRRSetResponse(String opcNextPage, Integer opcTotalItems, String opcRequestId, String eTag, RRSet rRSet) {
        this.opcNextPage = opcNextPage;
        this.opcTotalItems = opcTotalItems;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.rRSet = rRSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public RRSet getRRSet() {
        return this.rRSet;
    }

    public static class Builder {
        private String opcNextPage;
        private Integer opcTotalItems;
        private String opcRequestId;
        private String eTag;
        private RRSet rRSet;

        public Builder copy(GetRRSetResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.rRSet(o.getRRSet());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder rRSet(RRSet rRSet) {
            this.rRSet = rRSet;
            return this;
        }

        public GetRRSetResponse build() {
            return new GetRRSetResponse(this.opcNextPage, this.opcTotalItems, this.opcRequestId, this.eTag, this.rRSet);
        }

        public String toString() {
            return "GetRRSetResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcTotalItems=" + this.opcTotalItems + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", rRSet=" + this.rRSet + ")";
        }
    }
}

