/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.SteeringPolicy;
import java.beans.ConstructorProperties;

public class GetSteeringPolicyResponse {
    private String opcRequestId;
    private String eTag;
    private SteeringPolicy steeringPolicy;
    private boolean isNotModified;

    @ConstructorProperties(value={"opcRequestId", "eTag", "steeringPolicy", "isNotModified"})
    GetSteeringPolicyResponse(String opcRequestId, String eTag, SteeringPolicy steeringPolicy, boolean isNotModified) {
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.steeringPolicy = steeringPolicy;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public SteeringPolicy getSteeringPolicy() {
        return this.steeringPolicy;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    public static class Builder {
        private String opcRequestId;
        private String eTag;
        private SteeringPolicy steeringPolicy;
        private boolean isNotModified;

        public Builder copy(GetSteeringPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.steeringPolicy(o.getSteeringPolicy());
            this.isNotModified(o.isNotModified());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder steeringPolicy(SteeringPolicy steeringPolicy) {
            this.steeringPolicy = steeringPolicy;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public GetSteeringPolicyResponse build() {
            return new GetSteeringPolicyResponse(this.opcRequestId, this.eTag, this.steeringPolicy, this.isNotModified);
        }

        public String toString() {
            return "GetSteeringPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", steeringPolicy=" + this.steeringPolicy + ", isNotModified=" + this.isNotModified + ")";
        }
    }
}

