/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceAsync;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceAdminCredentialsConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceCertificateAuthorityCertificateConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceEncryptionPassphraseConverter;
import com.oracle.bmc.dts.internal.http.ListTransferAppliancesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferApplianceConverter;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceAsyncClient
implements TransferApplianceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferApplianceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferApplianceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateTransferApplianceResponse> createTransferAppliance(CreateTransferApplianceRequest request, AsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse> handler) {
        LOG.trace("Called async createTransferAppliance");
        final CreateTransferApplianceRequest interceptedRequest = CreateTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferApplianceResponse> transformer = CreateTransferApplianceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceRequest, CreateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferApplianceRequest, CreateTransferApplianceResponse> onSuccess = new SuccessConsumer<CreateTransferApplianceRequest, CreateTransferApplianceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferApplianceRequest> onError = new ErrorConsumer<CreateTransferApplianceRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferApplianceRequest, CreateTransferApplianceResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferApplianceRequest, CreateTransferApplianceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferApplianceRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferApplianceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferApplianceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferApplianceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTransferApplianceAdminCredentialsResponse> createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request, AsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> handler) {
        LOG.trace("Called async createTransferApplianceAdminCredentials");
        final CreateTransferApplianceAdminCredentialsRequest interceptedRequest = CreateTransferApplianceAdminCredentialsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferApplianceAdminCredentialsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferApplianceAdminCredentialsResponse> transformer = CreateTransferApplianceAdminCredentialsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> onSuccess = new SuccessConsumer<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferApplianceAdminCredentialsRequest> onError = new ErrorConsumer<CreateTransferApplianceAdminCredentialsRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.post(ib, interceptedRequest.getAdminPublicKey(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferApplianceAdminCredentialsRequest, CreateTransferApplianceAdminCredentialsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferApplianceAdminCredentialsRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferApplianceAdminCredentialsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAdminPublicKey(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferApplianceAdminCredentialsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.post(ib, interceptedRequest.getAdminPublicKey(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferApplianceAdminCredentialsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferApplianceResponse> deleteTransferAppliance(DeleteTransferApplianceRequest request, AsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> handler) {
        LOG.trace("Called async deleteTransferAppliance");
        final DeleteTransferApplianceRequest interceptedRequest = DeleteTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferApplianceResponse> transformer = DeleteTransferApplianceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> onSuccess = new SuccessConsumer<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTransferApplianceRequest> onError = new ErrorConsumer<DeleteTransferApplianceRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTransferApplianceRequest, DeleteTransferApplianceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTransferApplianceRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTransferApplianceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTransferApplianceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTransferApplianceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceResponse> getTransferAppliance(GetTransferApplianceRequest request, AsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse> handler) {
        LOG.trace("Called async getTransferAppliance");
        final GetTransferApplianceRequest interceptedRequest = GetTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceResponse> transformer = GetTransferApplianceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceRequest, GetTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferApplianceRequest, GetTransferApplianceResponse> onSuccess = new SuccessConsumer<GetTransferApplianceRequest, GetTransferApplianceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferApplianceRequest> onError = new ErrorConsumer<GetTransferApplianceRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferApplianceRequest, GetTransferApplianceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferApplianceRequest, GetTransferApplianceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferApplianceRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferApplianceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferApplianceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferApplianceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceCertificateAuthorityCertificateResponse> getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request, AsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> handler) {
        LOG.trace("Called async getTransferApplianceCertificateAuthorityCertificate");
        final GetTransferApplianceCertificateAuthorityCertificateRequest interceptedRequest = GetTransferApplianceCertificateAuthorityCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceCertificateAuthorityCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceCertificateAuthorityCertificateResponse> transformer = GetTransferApplianceCertificateAuthorityCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> onSuccess = new SuccessConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest> onError = new ErrorConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest, GetTransferApplianceCertificateAuthorityCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferApplianceCertificateAuthorityCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferApplianceCertificateAuthorityCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferApplianceCertificateAuthorityCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceEncryptionPassphraseResponse> getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request, AsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> handler) {
        LOG.trace("Called async getTransferApplianceEncryptionPassphrase");
        final GetTransferApplianceEncryptionPassphraseRequest interceptedRequest = GetTransferApplianceEncryptionPassphraseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceEncryptionPassphraseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceEncryptionPassphraseResponse> transformer = GetTransferApplianceEncryptionPassphraseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> onSuccess = new SuccessConsumer<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferApplianceEncryptionPassphraseRequest> onError = new ErrorConsumer<GetTransferApplianceEncryptionPassphraseRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferApplianceEncryptionPassphraseRequest, GetTransferApplianceEncryptionPassphraseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferApplianceEncryptionPassphraseRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferApplianceEncryptionPassphraseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferApplianceEncryptionPassphraseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferApplianceEncryptionPassphraseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferAppliancesResponse> listTransferAppliances(ListTransferAppliancesRequest request, AsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse> handler) {
        LOG.trace("Called async listTransferAppliances");
        final ListTransferAppliancesRequest interceptedRequest = ListTransferAppliancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferAppliancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferAppliancesResponse> transformer = ListTransferAppliancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferAppliancesRequest, ListTransferAppliancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTransferAppliancesRequest, ListTransferAppliancesResponse> onSuccess = new SuccessConsumer<ListTransferAppliancesRequest, ListTransferAppliancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTransferAppliancesRequest> onError = new ErrorConsumer<ListTransferAppliancesRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTransferAppliancesRequest, ListTransferAppliancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTransferAppliancesRequest, ListTransferAppliancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTransferAppliancesRequest> onError = handler == null ? null : new ErrorConsumer<ListTransferAppliancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTransferAppliancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTransferAppliancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferApplianceResponse> updateTransferAppliance(UpdateTransferApplianceRequest request, AsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> handler) {
        LOG.trace("Called async updateTransferAppliance");
        final UpdateTransferApplianceRequest interceptedRequest = UpdateTransferApplianceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferApplianceResponse> transformer = UpdateTransferApplianceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> onSuccess = new SuccessConsumer<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTransferApplianceRequest> onError = new ErrorConsumer<UpdateTransferApplianceRequest>(this, interceptedRequest);
                    TransferApplianceAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTransferApplianceRequest, UpdateTransferApplianceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTransferApplianceRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTransferApplianceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTransferApplianceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferApplianceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTransferApplianceResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public TransferApplianceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferApplianceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

