/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceEntitlementAsync;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceEntitlementConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceEntitlementConverter;
import com.oracle.bmc.dts.internal.http.ListTransferApplianceEntitlementConverter;
import com.oracle.bmc.dts.requests.CreateTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.ListTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.ListTransferApplianceEntitlementResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceEntitlementAsyncClient
implements TransferApplianceEntitlementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceEntitlementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCEENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferApplianceEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferApplianceEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateTransferApplianceEntitlementResponse> createTransferApplianceEntitlement(CreateTransferApplianceEntitlementRequest request, AsyncHandler<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse> handler) {
        LOG.trace("Called async createTransferApplianceEntitlement");
        final CreateTransferApplianceEntitlementRequest interceptedRequest = CreateTransferApplianceEntitlementConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferApplianceEntitlementConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferApplianceEntitlementResponse> transformer = CreateTransferApplianceEntitlementConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse> onSuccess = new SuccessConsumer<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferApplianceEntitlementRequest> onError = new ErrorConsumer<CreateTransferApplianceEntitlementRequest>(this, interceptedRequest);
                    TransferApplianceEntitlementAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferApplianceEntitlementDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferApplianceEntitlementRequest, CreateTransferApplianceEntitlementResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferApplianceEntitlementRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferApplianceEntitlementRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTransferApplianceEntitlementDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferApplianceEntitlementResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceEntitlementAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferApplianceEntitlementDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferApplianceEntitlementResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferApplianceEntitlementResponse> getTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request, AsyncHandler<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> handler) {
        LOG.trace("Called async getTransferApplianceEntitlement");
        final GetTransferApplianceEntitlementRequest interceptedRequest = GetTransferApplianceEntitlementConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferApplianceEntitlementConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferApplianceEntitlementResponse> transformer = GetTransferApplianceEntitlementConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> onSuccess = new SuccessConsumer<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferApplianceEntitlementRequest> onError = new ErrorConsumer<GetTransferApplianceEntitlementRequest>(this, interceptedRequest);
                    TransferApplianceEntitlementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferApplianceEntitlementRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferApplianceEntitlementRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferApplianceEntitlementResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceEntitlementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferApplianceEntitlementResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferApplianceEntitlementResponse> listTransferApplianceEntitlement(ListTransferApplianceEntitlementRequest request, AsyncHandler<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse> handler) {
        LOG.trace("Called async listTransferApplianceEntitlement");
        final ListTransferApplianceEntitlementRequest interceptedRequest = ListTransferApplianceEntitlementConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferApplianceEntitlementConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferApplianceEntitlementResponse> transformer = ListTransferApplianceEntitlementConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse> onSuccess = new SuccessConsumer<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTransferApplianceEntitlementRequest> onError = new ErrorConsumer<ListTransferApplianceEntitlementRequest>(this, interceptedRequest);
                    TransferApplianceEntitlementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTransferApplianceEntitlementRequest, ListTransferApplianceEntitlementResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTransferApplianceEntitlementRequest> onError = handler == null ? null : new ErrorConsumer<ListTransferApplianceEntitlementRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTransferApplianceEntitlementResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferApplianceEntitlementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTransferApplianceEntitlementResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceEntitlementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public TransferApplianceEntitlementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferApplianceEntitlementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

