/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferDeviceAsync;
import com.oracle.bmc.dts.internal.http.CreateTransferDeviceConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferDeviceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferDeviceConverter;
import com.oracle.bmc.dts.internal.http.ListTransferDevicesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferDeviceConverter;
import com.oracle.bmc.dts.requests.CreateTransferDeviceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferDeviceRequest;
import com.oracle.bmc.dts.requests.GetTransferDeviceRequest;
import com.oracle.bmc.dts.requests.ListTransferDevicesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferDeviceRequest;
import com.oracle.bmc.dts.responses.CreateTransferDeviceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferDeviceResponse;
import com.oracle.bmc.dts.responses.GetTransferDeviceResponse;
import com.oracle.bmc.dts.responses.ListTransferDevicesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferDeviceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDeviceAsyncClient
implements TransferDeviceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferDeviceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERDEVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferDeviceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferDeviceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferDeviceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferDeviceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferDeviceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferDeviceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferDeviceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateTransferDeviceResponse> createTransferDevice(CreateTransferDeviceRequest request, AsyncHandler<CreateTransferDeviceRequest, CreateTransferDeviceResponse> handler) {
        LOG.trace("Called async createTransferDevice");
        final CreateTransferDeviceRequest interceptedRequest = CreateTransferDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferDeviceResponse> transformer = CreateTransferDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferDeviceRequest, CreateTransferDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferDeviceRequest, CreateTransferDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferDeviceRequest, CreateTransferDeviceResponse> onSuccess = new SuccessConsumer<CreateTransferDeviceRequest, CreateTransferDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferDeviceRequest> onError = new ErrorConsumer<CreateTransferDeviceRequest>(this, interceptedRequest);
                    TransferDeviceAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferDeviceRequest, CreateTransferDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferDeviceRequest, CreateTransferDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferDeviceRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferDeviceAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferDeviceResponse> deleteTransferDevice(DeleteTransferDeviceRequest request, AsyncHandler<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse> handler) {
        LOG.trace("Called async deleteTransferDevice");
        final DeleteTransferDeviceRequest interceptedRequest = DeleteTransferDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferDeviceResponse> transformer = DeleteTransferDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse> onSuccess = new SuccessConsumer<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTransferDeviceRequest> onError = new ErrorConsumer<DeleteTransferDeviceRequest>(this, interceptedRequest);
                    TransferDeviceAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTransferDeviceRequest, DeleteTransferDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTransferDeviceRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTransferDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTransferDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferDeviceAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTransferDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferDeviceResponse> getTransferDevice(GetTransferDeviceRequest request, AsyncHandler<GetTransferDeviceRequest, GetTransferDeviceResponse> handler) {
        LOG.trace("Called async getTransferDevice");
        final GetTransferDeviceRequest interceptedRequest = GetTransferDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferDeviceResponse> transformer = GetTransferDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferDeviceRequest, GetTransferDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferDeviceRequest, GetTransferDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferDeviceRequest, GetTransferDeviceResponse> onSuccess = new SuccessConsumer<GetTransferDeviceRequest, GetTransferDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferDeviceRequest> onError = new ErrorConsumer<GetTransferDeviceRequest>(this, interceptedRequest);
                    TransferDeviceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferDeviceRequest, GetTransferDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferDeviceRequest, GetTransferDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferDeviceRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferDeviceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferDeviceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferDevicesResponse> listTransferDevices(ListTransferDevicesRequest request, AsyncHandler<ListTransferDevicesRequest, ListTransferDevicesResponse> handler) {
        LOG.trace("Called async listTransferDevices");
        final ListTransferDevicesRequest interceptedRequest = ListTransferDevicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferDevicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferDevicesResponse> transformer = ListTransferDevicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTransferDevicesRequest, ListTransferDevicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferDevicesRequest, ListTransferDevicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTransferDevicesRequest, ListTransferDevicesResponse> onSuccess = new SuccessConsumer<ListTransferDevicesRequest, ListTransferDevicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTransferDevicesRequest> onError = new ErrorConsumer<ListTransferDevicesRequest>(this, interceptedRequest);
                    TransferDeviceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTransferDevicesRequest, ListTransferDevicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTransferDevicesRequest, ListTransferDevicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTransferDevicesRequest> onError = handler == null ? null : new ErrorConsumer<ListTransferDevicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTransferDevicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferDeviceAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTransferDevicesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferDeviceResponse> updateTransferDevice(UpdateTransferDeviceRequest request, AsyncHandler<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse> handler) {
        LOG.trace("Called async updateTransferDevice");
        final UpdateTransferDeviceRequest interceptedRequest = UpdateTransferDeviceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferDeviceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferDeviceResponse> transformer = UpdateTransferDeviceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse> onSuccess = new SuccessConsumer<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTransferDeviceRequest> onError = new ErrorConsumer<UpdateTransferDeviceRequest>(this, interceptedRequest);
                    TransferDeviceAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTransferDeviceRequest, UpdateTransferDeviceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTransferDeviceRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTransferDeviceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTransferDeviceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferDeviceAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferDeviceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTransferDeviceResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferDeviceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public TransferDeviceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferDeviceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

