/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferJobAsync;
import com.oracle.bmc.dts.internal.http.ChangeTransferJobCompartmentConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferJobConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferJobConverter;
import com.oracle.bmc.dts.internal.http.GetTransferJobConverter;
import com.oracle.bmc.dts.internal.http.ListTransferJobsConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferJobConverter;
import com.oracle.bmc.dts.requests.ChangeTransferJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateTransferJobRequest;
import com.oracle.bmc.dts.requests.DeleteTransferJobRequest;
import com.oracle.bmc.dts.requests.GetTransferJobRequest;
import com.oracle.bmc.dts.requests.ListTransferJobsRequest;
import com.oracle.bmc.dts.requests.UpdateTransferJobRequest;
import com.oracle.bmc.dts.responses.ChangeTransferJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateTransferJobResponse;
import com.oracle.bmc.dts.responses.DeleteTransferJobResponse;
import com.oracle.bmc.dts.responses.GetTransferJobResponse;
import com.oracle.bmc.dts.responses.ListTransferJobsResponse;
import com.oracle.bmc.dts.responses.UpdateTransferJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJobAsyncClient
implements TransferJobAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferJobAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeTransferJobCompartmentResponse> changeTransferJobCompartment(ChangeTransferJobCompartmentRequest request, AsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> handler) {
        LOG.trace("Called async changeTransferJobCompartment");
        final ChangeTransferJobCompartmentRequest interceptedRequest = ChangeTransferJobCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeTransferJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeTransferJobCompartmentResponse> transformer = ChangeTransferJobCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> onSuccess = new SuccessConsumer<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeTransferJobCompartmentRequest> onError = new ErrorConsumer<ChangeTransferJobCompartmentRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.post(ib, interceptedRequest.getChangeTransferJobCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeTransferJobCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeTransferJobCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeTransferJobCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeTransferJobCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.post(ib, interceptedRequest.getChangeTransferJobCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeTransferJobCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTransferJobResponse> createTransferJob(CreateTransferJobRequest request, AsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse> handler) {
        LOG.trace("Called async createTransferJob");
        final CreateTransferJobRequest interceptedRequest = CreateTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferJobResponse> transformer = CreateTransferJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferJobRequest, CreateTransferJobResponse> onSuccess = new SuccessConsumer<CreateTransferJobRequest, CreateTransferJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferJobRequest> onError = new ErrorConsumer<CreateTransferJobRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferJobRequest, CreateTransferJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferJobRequest, CreateTransferJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferJobRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTransferJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferJobResponse> deleteTransferJob(DeleteTransferJobRequest request, AsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse> handler) {
        LOG.trace("Called async deleteTransferJob");
        final DeleteTransferJobRequest interceptedRequest = DeleteTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferJobResponse> transformer = DeleteTransferJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTransferJobRequest, DeleteTransferJobResponse> onSuccess = new SuccessConsumer<DeleteTransferJobRequest, DeleteTransferJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTransferJobRequest> onError = new ErrorConsumer<DeleteTransferJobRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTransferJobRequest, DeleteTransferJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTransferJobRequest, DeleteTransferJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTransferJobRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTransferJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTransferJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTransferJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferJobResponse> getTransferJob(GetTransferJobRequest request, AsyncHandler<GetTransferJobRequest, GetTransferJobResponse> handler) {
        LOG.trace("Called async getTransferJob");
        final GetTransferJobRequest interceptedRequest = GetTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferJobResponse> transformer = GetTransferJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferJobRequest, GetTransferJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferJobRequest, GetTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferJobRequest, GetTransferJobResponse> onSuccess = new SuccessConsumer<GetTransferJobRequest, GetTransferJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferJobRequest> onError = new ErrorConsumer<GetTransferJobRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferJobRequest, GetTransferJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferJobRequest, GetTransferJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferJobRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferJobsResponse> listTransferJobs(ListTransferJobsRequest request, AsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse> handler) {
        LOG.trace("Called async listTransferJobs");
        final ListTransferJobsRequest interceptedRequest = ListTransferJobsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferJobsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferJobsResponse> transformer = ListTransferJobsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTransferJobsRequest, ListTransferJobsResponse> onSuccess = new SuccessConsumer<ListTransferJobsRequest, ListTransferJobsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTransferJobsRequest> onError = new ErrorConsumer<ListTransferJobsRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTransferJobsRequest, ListTransferJobsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTransferJobsRequest, ListTransferJobsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTransferJobsRequest> onError = handler == null ? null : new ErrorConsumer<ListTransferJobsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTransferJobsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTransferJobsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferJobResponse> updateTransferJob(UpdateTransferJobRequest request, AsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse> handler) {
        LOG.trace("Called async updateTransferJob");
        final UpdateTransferJobRequest interceptedRequest = UpdateTransferJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferJobResponse> transformer = UpdateTransferJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTransferJobRequest, UpdateTransferJobResponse> onSuccess = new SuccessConsumer<UpdateTransferJobRequest, UpdateTransferJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTransferJobRequest> onError = new ErrorConsumer<UpdateTransferJobRequest>(this, interceptedRequest);
                    TransferJobAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTransferJobRequest, UpdateTransferJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTransferJobRequest, UpdateTransferJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTransferJobRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTransferJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTransferJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTransferJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferJobAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTransferJobResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public TransferJobAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferJobAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

