/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferPackageAsync;
import com.oracle.bmc.dts.internal.http.AttachDevicesToTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DetachDevicesFromTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.GetTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.ListTransferPackagesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferPackageConverter;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPackageAsyncClient
implements TransferPackageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferPackageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AttachDevicesToTransferPackageResponse> attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request, AsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> handler) {
        LOG.trace("Called async attachDevicesToTransferPackage");
        final AttachDevicesToTransferPackageRequest interceptedRequest = AttachDevicesToTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachDevicesToTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachDevicesToTransferPackageResponse> transformer = AttachDevicesToTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> onSuccess = new SuccessConsumer<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachDevicesToTransferPackageRequest> onError = new ErrorConsumer<AttachDevicesToTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getAttachDevicesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachDevicesToTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<AttachDevicesToTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachDevicesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachDevicesToTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getAttachDevicesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachDevicesToTransferPackageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTransferPackageResponse> createTransferPackage(CreateTransferPackageRequest request, AsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse> handler) {
        LOG.trace("Called async createTransferPackage");
        final CreateTransferPackageRequest interceptedRequest = CreateTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTransferPackageResponse> transformer = CreateTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTransferPackageRequest, CreateTransferPackageResponse> onSuccess = new SuccessConsumer<CreateTransferPackageRequest, CreateTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTransferPackageRequest> onError = new ErrorConsumer<CreateTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTransferPackageRequest, CreateTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTransferPackageRequest, CreateTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<CreateTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getCreateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTransferPackageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTransferPackageResponse> deleteTransferPackage(DeleteTransferPackageRequest request, AsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse> handler) {
        LOG.trace("Called async deleteTransferPackage");
        final DeleteTransferPackageRequest interceptedRequest = DeleteTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTransferPackageResponse> transformer = DeleteTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTransferPackageRequest, DeleteTransferPackageResponse> onSuccess = new SuccessConsumer<DeleteTransferPackageRequest, DeleteTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTransferPackageRequest> onError = new ErrorConsumer<DeleteTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTransferPackageRequest, DeleteTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTransferPackageRequest, DeleteTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTransferPackageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachDevicesFromTransferPackageResponse> detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request, AsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> handler) {
        LOG.trace("Called async detachDevicesFromTransferPackage");
        final DetachDevicesFromTransferPackageRequest interceptedRequest = DetachDevicesFromTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachDevicesFromTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachDevicesFromTransferPackageResponse> transformer = DetachDevicesFromTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> onSuccess = new SuccessConsumer<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachDevicesFromTransferPackageRequest> onError = new ErrorConsumer<DetachDevicesFromTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getDetachDevicesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachDevicesFromTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<DetachDevicesFromTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getDetachDevicesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachDevicesFromTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.post(ib, interceptedRequest.getDetachDevicesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachDevicesFromTransferPackageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTransferPackageResponse> getTransferPackage(GetTransferPackageRequest request, AsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse> handler) {
        LOG.trace("Called async getTransferPackage");
        final GetTransferPackageRequest interceptedRequest = GetTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTransferPackageResponse> transformer = GetTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTransferPackageRequest, GetTransferPackageResponse> onSuccess = new SuccessConsumer<GetTransferPackageRequest, GetTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTransferPackageRequest> onError = new ErrorConsumer<GetTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTransferPackageRequest, GetTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTransferPackageRequest, GetTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<GetTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTransferPackageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTransferPackagesResponse> listTransferPackages(ListTransferPackagesRequest request, AsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse> handler) {
        LOG.trace("Called async listTransferPackages");
        final ListTransferPackagesRequest interceptedRequest = ListTransferPackagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTransferPackagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTransferPackagesResponse> transformer = ListTransferPackagesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTransferPackagesRequest, ListTransferPackagesResponse> onSuccess = new SuccessConsumer<ListTransferPackagesRequest, ListTransferPackagesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTransferPackagesRequest> onError = new ErrorConsumer<ListTransferPackagesRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTransferPackagesRequest, ListTransferPackagesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTransferPackagesRequest, ListTransferPackagesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTransferPackagesRequest> onError = handler == null ? null : new ErrorConsumer<ListTransferPackagesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTransferPackagesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTransferPackagesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTransferPackageResponse> updateTransferPackage(UpdateTransferPackageRequest request, AsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse> handler) {
        LOG.trace("Called async updateTransferPackage");
        final UpdateTransferPackageRequest interceptedRequest = UpdateTransferPackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTransferPackageResponse> transformer = UpdateTransferPackageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTransferPackageRequest, UpdateTransferPackageResponse> onSuccess = new SuccessConsumer<UpdateTransferPackageRequest, UpdateTransferPackageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTransferPackageRequest> onError = new ErrorConsumer<UpdateTransferPackageRequest>(this, interceptedRequest);
                    TransferPackageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTransferPackageRequest, UpdateTransferPackageResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTransferPackageRequest, UpdateTransferPackageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTransferPackageRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTransferPackageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTransferPackageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return TransferPackageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateTransferPackageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTransferPackageResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferPackageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public TransferPackageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferPackageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

