/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dts.model.TransferJob;
import com.oracle.bmc.dts.requests.CreateTransferJobRequest;
import com.oracle.bmc.dts.responses.CreateTransferJobResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTransferJobConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTransferJobConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateTransferJobRequest interceptRequest(CreateTransferJobRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateTransferJobRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateTransferJobDetails(), (String)"createTransferJobDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20171001").path("transferJobs");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateTransferJobResponse> fromResponse() {
        Function<Response, CreateTransferJobResponse> transformer = new Function<Response, CreateTransferJobResponse>(){

            public CreateTransferJobResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for CreateTransferJobResponse");
                Function<Response, WithHeaders<TransferJob>> responseFn = RESPONSE_CONVERSION_FACTORY.create(TransferJob.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateTransferJobResponse.Builder builder = CreateTransferJobResponse.builder();
                builder.transferJob((TransferJob)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                CreateTransferJobResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

