/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dts.model.TransferPackage;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTransferPackageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTransferPackageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTransferPackageRequest interceptRequest(GetTransferPackageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTransferPackageRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20171001").path("transferJobs").path(HttpUtils.encodePathSegment(request.getId())).path("transferPackages").path(HttpUtils.encodePathSegment(request.getTransferPackageLabel()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetTransferPackageResponse> fromResponse() {
        Function<Response, GetTransferPackageResponse> transformer = new Function<Response, GetTransferPackageResponse>(){

            public GetTransferPackageResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for GetTransferPackageResponse");
                Function<Response, WithHeaders<TransferPackage>> responseFn = RESPONSE_CONVERSION_FACTORY.create(TransferPackage.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetTransferPackageResponse.Builder builder = GetTransferPackageResponse.builder();
                builder.transferPackage((TransferPackage)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                GetTransferPackageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

