/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.AttachDevicesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachDevicesToTransferPackageRequest
extends BmcRequest {
    private String id;
    private String transferPackageLabel;
    private AttachDevicesDetails attachDevicesDetails;

    @ConstructorProperties(value={"id", "transferPackageLabel", "attachDevicesDetails"})
    AttachDevicesToTransferPackageRequest(String id, String transferPackageLabel, AttachDevicesDetails attachDevicesDetails) {
        this.id = id;
        this.transferPackageLabel = transferPackageLabel;
        this.attachDevicesDetails = attachDevicesDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public AttachDevicesDetails getAttachDevicesDetails() {
        return this.attachDevicesDetails;
    }

    public static class Builder {
        private String id;
        private String transferPackageLabel;
        private AttachDevicesDetails attachDevicesDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachDevicesToTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.attachDevicesDetails(o.getAttachDevicesDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachDevicesToTransferPackageRequest build() {
            AttachDevicesToTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public Builder attachDevicesDetails(AttachDevicesDetails attachDevicesDetails) {
            this.attachDevicesDetails = attachDevicesDetails;
            return this;
        }

        public AttachDevicesToTransferPackageRequest buildWithoutInvocationCallback() {
            return new AttachDevicesToTransferPackageRequest(this.id, this.transferPackageLabel, this.attachDevicesDetails);
        }

        public String toString() {
            return "AttachDevicesToTransferPackageRequest.Builder(id=" + this.id + ", transferPackageLabel=" + this.transferPackageLabel + ", attachDevicesDetails=" + this.attachDevicesDetails + ")";
        }
    }
}

