/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.CreateTransferDeviceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTransferDeviceRequest
extends BmcRequest {
    private String id;
    private CreateTransferDeviceDetails createTransferDeviceDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"id", "createTransferDeviceDetails", "opcRetryToken"})
    CreateTransferDeviceRequest(String id, CreateTransferDeviceDetails createTransferDeviceDetails, String opcRetryToken) {
        this.id = id;
        this.createTransferDeviceDetails = createTransferDeviceDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public CreateTransferDeviceDetails getCreateTransferDeviceDetails() {
        return this.createTransferDeviceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String id;
        private CreateTransferDeviceDetails createTransferDeviceDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferDeviceRequest o) {
            this.id(o.getId());
            this.createTransferDeviceDetails(o.getCreateTransferDeviceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferDeviceRequest build() {
            CreateTransferDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createTransferDeviceDetails(CreateTransferDeviceDetails createTransferDeviceDetails) {
            this.createTransferDeviceDetails = createTransferDeviceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateTransferDeviceRequest buildWithoutInvocationCallback() {
            return new CreateTransferDeviceRequest(this.id, this.createTransferDeviceDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateTransferDeviceRequest.Builder(id=" + this.id + ", createTransferDeviceDetails=" + this.createTransferDeviceDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

