/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.DetachDevicesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DetachDevicesFromTransferPackageRequest
extends BmcRequest {
    private String id;
    private String transferPackageLabel;
    private DetachDevicesDetails detachDevicesDetails;

    @ConstructorProperties(value={"id", "transferPackageLabel", "detachDevicesDetails"})
    DetachDevicesFromTransferPackageRequest(String id, String transferPackageLabel, DetachDevicesDetails detachDevicesDetails) {
        this.id = id;
        this.transferPackageLabel = transferPackageLabel;
        this.detachDevicesDetails = detachDevicesDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public DetachDevicesDetails getDetachDevicesDetails() {
        return this.detachDevicesDetails;
    }

    public static class Builder {
        private String id;
        private String transferPackageLabel;
        private DetachDevicesDetails detachDevicesDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachDevicesFromTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.detachDevicesDetails(o.getDetachDevicesDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachDevicesFromTransferPackageRequest build() {
            DetachDevicesFromTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public Builder detachDevicesDetails(DetachDevicesDetails detachDevicesDetails) {
            this.detachDevicesDetails = detachDevicesDetails;
            return this;
        }

        public DetachDevicesFromTransferPackageRequest buildWithoutInvocationCallback() {
            return new DetachDevicesFromTransferPackageRequest(this.id, this.transferPackageLabel, this.detachDevicesDetails);
        }

        public String toString() {
            return "DetachDevicesFromTransferPackageRequest.Builder(id=" + this.id + ", transferPackageLabel=" + this.transferPackageLabel + ", detachDevicesDetails=" + this.detachDevicesDetails + ")";
        }
    }
}

