/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTransferApplianceEntitlementRequest
extends BmcRequest {
    private String compartmentId;
    private String id;
    private String displayName;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "id", "displayName", "opcRequestId"})
    ListTransferApplianceEntitlementRequest(String compartmentId, String id, String displayName, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.id = id;
        this.displayName = displayName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String compartmentId;
        private String id;
        private String displayName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTransferApplianceEntitlementRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.id(o.getId());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTransferApplianceEntitlementRequest build() {
            ListTransferApplianceEntitlementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListTransferApplianceEntitlementRequest buildWithoutInvocationCallback() {
            return new ListTransferApplianceEntitlementRequest(this.compartmentId, this.id, this.displayName, this.opcRequestId);
        }

        public String toString() {
            return "ListTransferApplianceEntitlementRequest.Builder(compartmentId=" + this.compartmentId + ", id=" + this.id + ", displayName=" + this.displayName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

