/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.UpdateTransferPackageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTransferPackageRequest
extends BmcRequest {
    private String id;
    private String transferPackageLabel;
    private UpdateTransferPackageDetails updateTransferPackageDetails;
    private String ifMatch;

    @ConstructorProperties(value={"id", "transferPackageLabel", "updateTransferPackageDetails", "ifMatch"})
    UpdateTransferPackageRequest(String id, String transferPackageLabel, UpdateTransferPackageDetails updateTransferPackageDetails, String ifMatch) {
        this.id = id;
        this.transferPackageLabel = transferPackageLabel;
        this.updateTransferPackageDetails = updateTransferPackageDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public UpdateTransferPackageDetails getUpdateTransferPackageDetails() {
        return this.updateTransferPackageDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String id;
        private String transferPackageLabel;
        private UpdateTransferPackageDetails updateTransferPackageDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.updateTransferPackageDetails(o.getUpdateTransferPackageDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTransferPackageRequest build() {
            UpdateTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public Builder updateTransferPackageDetails(UpdateTransferPackageDetails updateTransferPackageDetails) {
            this.updateTransferPackageDetails = updateTransferPackageDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateTransferPackageRequest buildWithoutInvocationCallback() {
            return new UpdateTransferPackageRequest(this.id, this.transferPackageLabel, this.updateTransferPackageDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateTransferPackageRequest.Builder(id=" + this.id + ", transferPackageLabel=" + this.transferPackageLabel + ", updateTransferPackageDetails=" + this.updateTransferPackageDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

