/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.NewTransferDevice;
import java.beans.ConstructorProperties;

public class CreateTransferDeviceResponse {
    private String opcRequestId;
    private String etag;
    private NewTransferDevice newTransferDevice;

    @ConstructorProperties(value={"opcRequestId", "etag", "newTransferDevice"})
    CreateTransferDeviceResponse(String opcRequestId, String etag, NewTransferDevice newTransferDevice) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.newTransferDevice = newTransferDevice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public NewTransferDevice getNewTransferDevice() {
        return this.newTransferDevice;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private NewTransferDevice newTransferDevice;

        public Builder copy(CreateTransferDeviceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.newTransferDevice(o.getNewTransferDevice());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder newTransferDevice(NewTransferDevice newTransferDevice) {
            this.newTransferDevice = newTransferDevice;
            return this;
        }

        public CreateTransferDeviceResponse build() {
            return new CreateTransferDeviceResponse(this.opcRequestId, this.etag, this.newTransferDevice);
        }

        public String toString() {
            return "CreateTransferDeviceResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", newTransferDevice=" + this.newTransferDevice + ")";
        }
    }
}

