/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.TransferPackage;
import java.beans.ConstructorProperties;

public class CreateTransferPackageResponse {
    private String opcRequestId;
    private String etag;
    private TransferPackage transferPackage;

    @ConstructorProperties(value={"opcRequestId", "etag", "transferPackage"})
    CreateTransferPackageResponse(String opcRequestId, String etag, TransferPackage transferPackage) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.transferPackage = transferPackage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public TransferPackage getTransferPackage() {
        return this.transferPackage;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private TransferPackage transferPackage;

        public Builder copy(CreateTransferPackageResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.transferPackage(o.getTransferPackage());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder transferPackage(TransferPackage transferPackage) {
            this.transferPackage = transferPackage;
            return this;
        }

        public CreateTransferPackageResponse build() {
            return new CreateTransferPackageResponse(this.opcRequestId, this.etag, this.transferPackage);
        }

        public String toString() {
            return "CreateTransferPackageResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", transferPackage=" + this.transferPackage + ")";
        }
    }
}

