/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.ShippingVendors;
import java.beans.ConstructorProperties;

public class ListShippingVendorsResponse {
    private String opcRequestId;
    private ShippingVendors shippingVendors;

    @ConstructorProperties(value={"opcRequestId", "shippingVendors"})
    ListShippingVendorsResponse(String opcRequestId, ShippingVendors shippingVendors) {
        this.opcRequestId = opcRequestId;
        this.shippingVendors = shippingVendors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ShippingVendors getShippingVendors() {
        return this.shippingVendors;
    }

    public static class Builder {
        private String opcRequestId;
        private ShippingVendors shippingVendors;

        public Builder copy(ListShippingVendorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.shippingVendors(o.getShippingVendors());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder shippingVendors(ShippingVendors shippingVendors) {
            this.shippingVendors = shippingVendors;
            return this;
        }

        public ListShippingVendorsResponse build() {
            return new ListShippingVendorsResponse(this.opcRequestId, this.shippingVendors);
        }

        public String toString() {
            return "ListShippingVendorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", shippingVendors=" + this.shippingVendors + ")";
        }
    }
}

