/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.MultipleTransferAppliances;
import java.beans.ConstructorProperties;

public class ListTransferAppliancesResponse {
    private String opcRequestId;
    private MultipleTransferAppliances multipleTransferAppliances;

    @ConstructorProperties(value={"opcRequestId", "multipleTransferAppliances"})
    ListTransferAppliancesResponse(String opcRequestId, MultipleTransferAppliances multipleTransferAppliances) {
        this.opcRequestId = opcRequestId;
        this.multipleTransferAppliances = multipleTransferAppliances;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MultipleTransferAppliances getMultipleTransferAppliances() {
        return this.multipleTransferAppliances;
    }

    public static class Builder {
        private String opcRequestId;
        private MultipleTransferAppliances multipleTransferAppliances;

        public Builder copy(ListTransferAppliancesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.multipleTransferAppliances(o.getMultipleTransferAppliances());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder multipleTransferAppliances(MultipleTransferAppliances multipleTransferAppliances) {
            this.multipleTransferAppliances = multipleTransferAppliances;
            return this;
        }

        public ListTransferAppliancesResponse build() {
            return new ListTransferAppliancesResponse(this.opcRequestId, this.multipleTransferAppliances);
        }

        public String toString() {
            return "ListTransferAppliancesResponse.Builder(opcRequestId=" + this.opcRequestId + ", multipleTransferAppliances=" + this.multipleTransferAppliances + ")";
        }
    }
}

