/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.MultipleTransferDevices;
import java.beans.ConstructorProperties;

public class ListTransferDevicesResponse {
    private String opcRequestId;
    private MultipleTransferDevices multipleTransferDevices;

    @ConstructorProperties(value={"opcRequestId", "multipleTransferDevices"})
    ListTransferDevicesResponse(String opcRequestId, MultipleTransferDevices multipleTransferDevices) {
        this.opcRequestId = opcRequestId;
        this.multipleTransferDevices = multipleTransferDevices;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MultipleTransferDevices getMultipleTransferDevices() {
        return this.multipleTransferDevices;
    }

    public static class Builder {
        private String opcRequestId;
        private MultipleTransferDevices multipleTransferDevices;

        public Builder copy(ListTransferDevicesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.multipleTransferDevices(o.getMultipleTransferDevices());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder multipleTransferDevices(MultipleTransferDevices multipleTransferDevices) {
            this.multipleTransferDevices = multipleTransferDevices;
            return this;
        }

        public ListTransferDevicesResponse build() {
            return new ListTransferDevicesResponse(this.opcRequestId, this.multipleTransferDevices);
        }

        public String toString() {
            return "ListTransferDevicesResponse.Builder(opcRequestId=" + this.opcRequestId + ", multipleTransferDevices=" + this.multipleTransferDevices + ")";
        }
    }
}

