/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.TransferJobSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListTransferJobsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<TransferJobSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListTransferJobsResponse(String opcNextPage, String opcRequestId, List<TransferJobSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<TransferJobSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<TransferJobSummary> items;

        public Builder copy(ListTransferJobsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<TransferJobSummary> items) {
            this.items = items;
            return this;
        }

        public ListTransferJobsResponse build() {
            return new ListTransferJobsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListTransferJobsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

