/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.responses;

import com.oracle.bmc.dts.model.MultipleTransferPackages;
import java.beans.ConstructorProperties;

public class ListTransferPackagesResponse {
    private String opcRequestId;
    private MultipleTransferPackages multipleTransferPackages;

    @ConstructorProperties(value={"opcRequestId", "multipleTransferPackages"})
    ListTransferPackagesResponse(String opcRequestId, MultipleTransferPackages multipleTransferPackages) {
        this.opcRequestId = opcRequestId;
        this.multipleTransferPackages = multipleTransferPackages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MultipleTransferPackages getMultipleTransferPackages() {
        return this.multipleTransferPackages;
    }

    public static class Builder {
        private String opcRequestId;
        private MultipleTransferPackages multipleTransferPackages;

        public Builder copy(ListTransferPackagesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.multipleTransferPackages(o.getMultipleTransferPackages());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder multipleTransferPackages(MultipleTransferPackages multipleTransferPackages) {
            this.multipleTransferPackages = multipleTransferPackages;
            return this;
        }

        public ListTransferPackagesResponse build() {
            return new ListTransferPackagesResponse(this.opcRequestId, this.multipleTransferPackages);
        }

        public String toString() {
            return "ListTransferPackagesResponse.Builder(opcRequestId=" + this.opcRequestId + ", multipleTransferPackages=" + this.multipleTransferPackages + ")";
        }
    }
}

