/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.email.EmailAsync;
import com.oracle.bmc.email.internal.http.ChangeSenderCompartmentConverter;
import com.oracle.bmc.email.internal.http.CreateSenderConverter;
import com.oracle.bmc.email.internal.http.CreateSuppressionConverter;
import com.oracle.bmc.email.internal.http.DeleteSenderConverter;
import com.oracle.bmc.email.internal.http.DeleteSuppressionConverter;
import com.oracle.bmc.email.internal.http.GetSenderConverter;
import com.oracle.bmc.email.internal.http.GetSuppressionConverter;
import com.oracle.bmc.email.internal.http.ListSendersConverter;
import com.oracle.bmc.email.internal.http.ListSuppressionsConverter;
import com.oracle.bmc.email.internal.http.UpdateSenderConverter;
import com.oracle.bmc.email.requests.ChangeSenderCompartmentRequest;
import com.oracle.bmc.email.requests.CreateSenderRequest;
import com.oracle.bmc.email.requests.CreateSuppressionRequest;
import com.oracle.bmc.email.requests.DeleteSenderRequest;
import com.oracle.bmc.email.requests.DeleteSuppressionRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.UpdateSenderRequest;
import com.oracle.bmc.email.responses.ChangeSenderCompartmentResponse;
import com.oracle.bmc.email.responses.CreateSenderResponse;
import com.oracle.bmc.email.responses.CreateSuppressionResponse;
import com.oracle.bmc.email.responses.DeleteSenderResponse;
import com.oracle.bmc.email.responses.DeleteSuppressionResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.UpdateSenderResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAsyncClient
implements EmailAsync {
    private static final Logger LOG = LoggerFactory.getLogger(EmailAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EMAIL").serviceEndpointPrefix("email").serviceEndpointTemplate("https://email.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeSenderCompartmentResponse> changeSenderCompartment(ChangeSenderCompartmentRequest request, AsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> handler) {
        LOG.trace("Called async changeSenderCompartment");
        final ChangeSenderCompartmentRequest interceptedRequest = ChangeSenderCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSenderCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSenderCompartmentResponse> transformer = ChangeSenderCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> onSuccess = new SuccessConsumer<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeSenderCompartmentRequest> onError = new ErrorConsumer<ChangeSenderCompartmentRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.post(ib, interceptedRequest.getChangeSenderCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeSenderCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeSenderCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeSenderCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeSenderCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.post(ib, interceptedRequest.getChangeSenderCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeSenderCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSenderResponse> createSender(CreateSenderRequest request, AsyncHandler<CreateSenderRequest, CreateSenderResponse> handler) {
        LOG.trace("Called async createSender");
        final CreateSenderRequest interceptedRequest = CreateSenderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSenderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSenderResponse> transformer = CreateSenderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSenderRequest, CreateSenderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSenderRequest, CreateSenderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSenderRequest, CreateSenderResponse> onSuccess = new SuccessConsumer<CreateSenderRequest, CreateSenderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSenderRequest> onError = new ErrorConsumer<CreateSenderRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.post(ib, interceptedRequest.getCreateSenderDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSenderRequest, CreateSenderResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSenderRequest, CreateSenderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSenderRequest> onError = handler == null ? null : new ErrorConsumer<CreateSenderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSenderDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSenderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.post(ib, interceptedRequest.getCreateSenderDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSenderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSuppressionResponse> createSuppression(CreateSuppressionRequest request, AsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse> handler) {
        LOG.trace("Called async createSuppression");
        final CreateSuppressionRequest interceptedRequest = CreateSuppressionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSuppressionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSuppressionResponse> transformer = CreateSuppressionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSuppressionRequest, CreateSuppressionResponse> onSuccess = new SuccessConsumer<CreateSuppressionRequest, CreateSuppressionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSuppressionRequest> onError = new ErrorConsumer<CreateSuppressionRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.post(ib, interceptedRequest.getCreateSuppressionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSuppressionRequest, CreateSuppressionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSuppressionRequest, CreateSuppressionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSuppressionRequest> onError = handler == null ? null : new ErrorConsumer<CreateSuppressionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSuppressionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSuppressionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.post(ib, interceptedRequest.getCreateSuppressionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSuppressionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSenderResponse> deleteSender(DeleteSenderRequest request, AsyncHandler<DeleteSenderRequest, DeleteSenderResponse> handler) {
        LOG.trace("Called async deleteSender");
        final DeleteSenderRequest interceptedRequest = DeleteSenderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSenderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSenderResponse> transformer = DeleteSenderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSenderRequest, DeleteSenderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSenderRequest, DeleteSenderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSenderRequest, DeleteSenderResponse> onSuccess = new SuccessConsumer<DeleteSenderRequest, DeleteSenderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSenderRequest> onError = new ErrorConsumer<DeleteSenderRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSenderRequest, DeleteSenderResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSenderRequest, DeleteSenderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSenderRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSenderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSenderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSenderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSuppressionResponse> deleteSuppression(DeleteSuppressionRequest request, AsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse> handler) {
        LOG.trace("Called async deleteSuppression");
        final DeleteSuppressionRequest interceptedRequest = DeleteSuppressionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSuppressionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSuppressionResponse> transformer = DeleteSuppressionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSuppressionRequest, DeleteSuppressionResponse> onSuccess = new SuccessConsumer<DeleteSuppressionRequest, DeleteSuppressionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSuppressionRequest> onError = new ErrorConsumer<DeleteSuppressionRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSuppressionRequest, DeleteSuppressionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSuppressionRequest, DeleteSuppressionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSuppressionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSuppressionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSuppressionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSuppressionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSenderResponse> getSender(GetSenderRequest request, AsyncHandler<GetSenderRequest, GetSenderResponse> handler) {
        LOG.trace("Called async getSender");
        final GetSenderRequest interceptedRequest = GetSenderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSenderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSenderResponse> transformer = GetSenderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSenderRequest, GetSenderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSenderRequest, GetSenderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSenderRequest, GetSenderResponse> onSuccess = new SuccessConsumer<GetSenderRequest, GetSenderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSenderRequest> onError = new ErrorConsumer<GetSenderRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSenderRequest, GetSenderResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSenderRequest, GetSenderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSenderRequest> onError = handler == null ? null : new ErrorConsumer<GetSenderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSenderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSenderResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSuppressionResponse> getSuppression(GetSuppressionRequest request, AsyncHandler<GetSuppressionRequest, GetSuppressionResponse> handler) {
        LOG.trace("Called async getSuppression");
        final GetSuppressionRequest interceptedRequest = GetSuppressionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSuppressionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSuppressionResponse> transformer = GetSuppressionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSuppressionRequest, GetSuppressionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSuppressionRequest, GetSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSuppressionRequest, GetSuppressionResponse> onSuccess = new SuccessConsumer<GetSuppressionRequest, GetSuppressionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSuppressionRequest> onError = new ErrorConsumer<GetSuppressionRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSuppressionRequest, GetSuppressionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSuppressionRequest, GetSuppressionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSuppressionRequest> onError = handler == null ? null : new ErrorConsumer<GetSuppressionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSuppressionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSuppressionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSendersResponse> listSenders(ListSendersRequest request, AsyncHandler<ListSendersRequest, ListSendersResponse> handler) {
        LOG.trace("Called async listSenders");
        final ListSendersRequest interceptedRequest = ListSendersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSendersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSendersResponse> transformer = ListSendersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSendersRequest, ListSendersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSendersRequest, ListSendersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSendersRequest, ListSendersResponse> onSuccess = new SuccessConsumer<ListSendersRequest, ListSendersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSendersRequest> onError = new ErrorConsumer<ListSendersRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSendersRequest, ListSendersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSendersRequest, ListSendersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSendersRequest> onError = handler == null ? null : new ErrorConsumer<ListSendersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSendersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSendersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSuppressionsResponse> listSuppressions(ListSuppressionsRequest request, AsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse> handler) {
        LOG.trace("Called async listSuppressions");
        final ListSuppressionsRequest interceptedRequest = ListSuppressionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSuppressionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSuppressionsResponse> transformer = ListSuppressionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSuppressionsRequest, ListSuppressionsResponse> onSuccess = new SuccessConsumer<ListSuppressionsRequest, ListSuppressionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSuppressionsRequest> onError = new ErrorConsumer<ListSuppressionsRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSuppressionsRequest, ListSuppressionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSuppressionsRequest, ListSuppressionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSuppressionsRequest> onError = handler == null ? null : new ErrorConsumer<ListSuppressionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSuppressionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSuppressionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSenderResponse> updateSender(UpdateSenderRequest request, AsyncHandler<UpdateSenderRequest, UpdateSenderResponse> handler) {
        LOG.trace("Called async updateSender");
        final UpdateSenderRequest interceptedRequest = UpdateSenderConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSenderConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSenderResponse> transformer = UpdateSenderConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSenderRequest, UpdateSenderResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSenderRequest, UpdateSenderResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSenderRequest, UpdateSenderResponse> onSuccess = new SuccessConsumer<UpdateSenderRequest, UpdateSenderResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSenderRequest> onError = new ErrorConsumer<UpdateSenderRequest>(this, interceptedRequest);
                    EmailAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSenderDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSenderRequest, UpdateSenderResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSenderRequest, UpdateSenderResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSenderRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSenderRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSenderDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSenderResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EmailAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSenderDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSenderResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EmailAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public EmailAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new EmailAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

