/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.email.model.SenderSummary;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSendersConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSendersConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSendersRequest interceptRequest(ListSendersRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSendersRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170907").path("senders");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        if (request.getEmailAddress() != null) {
            target = target.queryParam("emailAddress", HttpUtils.attemptEncodeQueryParam(request.getEmailAddress()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListSendersResponse> fromResponse() {
        Function<Response, ListSendersResponse> transformer = new Function<Response, ListSendersResponse>(){

            public ListSendersResponse apply(Response rawResponse) {
                Optional<List<String>> opcTotalItemsHeader;
                Optional<List<String>> opcPrevPageHeader;
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListSendersResponse");
                Function<Response, WithHeaders<List<SenderSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<SenderSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListSendersResponse.Builder builder = ListSendersResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.get(headers, "opc-prev-page")).isPresent()) {
                    builder.opcPrevPage(HeaderUtils.toValue("opc-prev-page", (String)((List)opcPrevPageHeader.get()).get(0), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get(headers, "opc-total-items")).isPresent()) {
                    builder.opcTotalItems(HeaderUtils.toValue("opc-total-items", (String)((List)opcTotalItemsHeader.get()).get(0), Integer.class));
                }
                ListSendersResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

