/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.email.model.SuppressionSummary;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSuppressionsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSuppressionsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSuppressionsRequest interceptRequest(ListSuppressionsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSuppressionsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170907").path("suppressions");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getEmailAddress() != null) {
            target = target.queryParam("emailAddress", HttpUtils.attemptEncodeQueryParam(request.getEmailAddress()));
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedGreaterThanOrEqualTo()));
        }
        if (request.getTimeCreatedLessThan() != null) {
            target = target.queryParam("timeCreatedLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedLessThan()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListSuppressionsResponse> fromResponse() {
        Function<Response, ListSuppressionsResponse> transformer = new Function<Response, ListSuppressionsResponse>(){

            public ListSuppressionsResponse apply(Response rawResponse) {
                Optional<List<String>> opcPrevPageHeader;
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListSuppressionsResponse");
                Function<Response, WithHeaders<List<SuppressionSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<SuppressionSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListSuppressionsResponse.Builder builder = ListSuppressionsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.get(headers, "opc-prev-page")).isPresent()) {
                    builder.opcPrevPage(HeaderUtils.toValue("opc-prev-page", (String)((List)opcPrevPageHeader.get()).get(0), String.class));
                }
                ListSuppressionsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

