/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.email.model.CreateSuppressionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateSuppressionRequest
extends BmcRequest {
    private CreateSuppressionDetails createSuppressionDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"createSuppressionDetails", "opcRequestId"})
    CreateSuppressionRequest(CreateSuppressionDetails createSuppressionDetails, String opcRequestId) {
        this.createSuppressionDetails = createSuppressionDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateSuppressionDetails getCreateSuppressionDetails() {
        return this.createSuppressionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateSuppressionDetails createSuppressionDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSuppressionRequest o) {
            this.createSuppressionDetails(o.getCreateSuppressionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSuppressionRequest build() {
            CreateSuppressionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createSuppressionDetails(CreateSuppressionDetails createSuppressionDetails) {
            this.createSuppressionDetails = createSuppressionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateSuppressionRequest buildWithoutInvocationCallback() {
            return new CreateSuppressionRequest(this.createSuppressionDetails, this.opcRequestId);
        }

        public String toString() {
            return "CreateSuppressionRequest.Builder(createSuppressionDetails=" + this.createSuppressionDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

