/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSuppressionRequest
extends BmcRequest {
    private String suppressionId;
    private String opcRequestId;

    @ConstructorProperties(value={"suppressionId", "opcRequestId"})
    GetSuppressionRequest(String suppressionId, String opcRequestId) {
        this.suppressionId = suppressionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSuppressionId() {
        return this.suppressionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String suppressionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSuppressionRequest o) {
            this.suppressionId(o.getSuppressionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSuppressionRequest build() {
            GetSuppressionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder suppressionId(String suppressionId) {
            this.suppressionId = suppressionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSuppressionRequest buildWithoutInvocationCallback() {
            return new GetSuppressionRequest(this.suppressionId, this.opcRequestId);
        }

        public String toString() {
            return "GetSuppressionRequest.Builder(suppressionId=" + this.suppressionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

