/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.responses;

import com.oracle.bmc.email.model.Sender;
import java.beans.ConstructorProperties;

public class GetSenderResponse {
    private String opcRequestId;
    private String etag;
    private Sender sender;

    @ConstructorProperties(value={"opcRequestId", "etag", "sender"})
    GetSenderResponse(String opcRequestId, String etag, Sender sender) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.sender = sender;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Sender getSender() {
        return this.sender;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Sender sender;

        public Builder copy(GetSenderResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.sender(o.getSender());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public GetSenderResponse build() {
            return new GetSenderResponse(this.opcRequestId, this.etag, this.sender);
        }

        public String toString() {
            return "GetSenderResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", sender=" + this.sender + ")";
        }
    }
}

