/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.responses;

import com.oracle.bmc.email.model.Suppression;
import java.beans.ConstructorProperties;

public class GetSuppressionResponse {
    private String opcRequestId;
    private Suppression suppression;

    @ConstructorProperties(value={"opcRequestId", "suppression"})
    GetSuppressionResponse(String opcRequestId, Suppression suppression) {
        this.opcRequestId = opcRequestId;
        this.suppression = suppression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public static class Builder {
        private String opcRequestId;
        private Suppression suppression;

        public Builder copy(GetSuppressionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.suppression(o.getSuppression());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder suppression(Suppression suppression) {
            this.suppression = suppression;
            return this;
        }

        public GetSuppressionResponse build() {
            return new GetSuppressionResponse(this.opcRequestId, this.suppression);
        }

        public String toString() {
            return "GetSuppressionResponse.Builder(opcRequestId=" + this.opcRequestId + ", suppression=" + this.suppression + ")";
        }
    }
}

