/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.responses;

import com.oracle.bmc.email.model.SenderSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListSendersResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcPrevPage;
    private Integer opcTotalItems;
    private List<SenderSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "opcPrevPage", "opcTotalItems", "items"})
    ListSendersResponse(String opcRequestId, String opcNextPage, String opcPrevPage, Integer opcTotalItems, List<SenderSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.opcTotalItems = opcTotalItems;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public List<SenderSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private String opcPrevPage;
        private Integer opcTotalItems;
        private List<SenderSummary> items;

        public Builder copy(ListSendersResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder items(List<SenderSummary> items) {
            this.items = items;
            return this;
        }

        public ListSendersResponse build() {
            return new ListSendersResponse(this.opcRequestId, this.opcNextPage, this.opcPrevPage, this.opcTotalItems, this.items);
        }

        public String toString() {
            return "ListSendersResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", opcPrevPage=" + this.opcPrevPage + ", opcTotalItems=" + this.opcTotalItems + ", items=" + this.items + ")";
        }
    }
}

