/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.responses;

import com.oracle.bmc.email.model.SuppressionSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListSuppressionsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcPrevPage;
    private List<SuppressionSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "opcPrevPage", "items"})
    ListSuppressionsResponse(String opcRequestId, String opcNextPage, String opcPrevPage, List<SuppressionSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public List<SuppressionSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private String opcPrevPage;
        private List<SuppressionSummary> items;

        public Builder copy(ListSuppressionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder items(List<SuppressionSummary> items) {
            this.items = items;
            return this;
        }

        public ListSuppressionsResponse build() {
            return new ListSuppressionsResponse(this.opcRequestId, this.opcNextPage, this.opcPrevPage, this.items);
        }

        public String toString() {
            return "ListSuppressionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", opcPrevPage=" + this.opcPrevPage + ", items=" + this.items + ")";
        }
    }
}

