/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.events.EventsAsync;
import com.oracle.bmc.events.internal.http.ChangeRuleCompartmentConverter;
import com.oracle.bmc.events.internal.http.CreateRuleConverter;
import com.oracle.bmc.events.internal.http.DeleteRuleConverter;
import com.oracle.bmc.events.internal.http.GetRuleConverter;
import com.oracle.bmc.events.internal.http.ListRulesConverter;
import com.oracle.bmc.events.internal.http.UpdateRuleConverter;
import com.oracle.bmc.events.requests.ChangeRuleCompartmentRequest;
import com.oracle.bmc.events.requests.CreateRuleRequest;
import com.oracle.bmc.events.requests.DeleteRuleRequest;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.requests.UpdateRuleRequest;
import com.oracle.bmc.events.responses.ChangeRuleCompartmentResponse;
import com.oracle.bmc.events.responses.CreateRuleResponse;
import com.oracle.bmc.events.responses.DeleteRuleResponse;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.events.responses.UpdateRuleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsAsyncClient
implements EventsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(EventsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://events.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public EventsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EventsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EventsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EventsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EventsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EventsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EventsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeRuleCompartmentResponse> changeRuleCompartment(ChangeRuleCompartmentRequest request, AsyncHandler<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse> handler) {
        LOG.trace("Called async changeRuleCompartment");
        final ChangeRuleCompartmentRequest interceptedRequest = ChangeRuleCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeRuleCompartmentResponse> transformer = ChangeRuleCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse> onSuccess = new SuccessConsumer<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeRuleCompartmentRequest> onError = new ErrorConsumer<ChangeRuleCompartmentRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.post(ib, interceptedRequest.getChangeRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeRuleCompartmentRequest, ChangeRuleCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeRuleCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeRuleCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeRuleCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.post(ib, interceptedRequest.getChangeRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeRuleCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateRuleResponse> createRule(CreateRuleRequest request, AsyncHandler<CreateRuleRequest, CreateRuleResponse> handler) {
        LOG.trace("Called async createRule");
        final CreateRuleRequest interceptedRequest = CreateRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateRuleResponse> transformer = CreateRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateRuleRequest, CreateRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateRuleRequest, CreateRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateRuleRequest, CreateRuleResponse> onSuccess = new SuccessConsumer<CreateRuleRequest, CreateRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateRuleRequest> onError = new ErrorConsumer<CreateRuleRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.post(ib, interceptedRequest.getCreateRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateRuleRequest, CreateRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateRuleRequest, CreateRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateRuleRequest> onError = handler == null ? null : new ErrorConsumer<CreateRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.post(ib, interceptedRequest.getCreateRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteRuleResponse> deleteRule(DeleteRuleRequest request, AsyncHandler<DeleteRuleRequest, DeleteRuleResponse> handler) {
        LOG.trace("Called async deleteRule");
        final DeleteRuleRequest interceptedRequest = DeleteRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteRuleResponse> transformer = DeleteRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteRuleRequest, DeleteRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteRuleRequest, DeleteRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteRuleRequest, DeleteRuleResponse> onSuccess = new SuccessConsumer<DeleteRuleRequest, DeleteRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteRuleRequest> onError = new ErrorConsumer<DeleteRuleRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteRuleRequest, DeleteRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteRuleRequest, DeleteRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteRuleRequest> onError = handler == null ? null : new ErrorConsumer<DeleteRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetRuleResponse> getRule(GetRuleRequest request, AsyncHandler<GetRuleRequest, GetRuleResponse> handler) {
        LOG.trace("Called async getRule");
        final GetRuleRequest interceptedRequest = GetRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetRuleResponse> transformer = GetRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetRuleRequest, GetRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetRuleRequest, GetRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetRuleRequest, GetRuleResponse> onSuccess = new SuccessConsumer<GetRuleRequest, GetRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetRuleRequest> onError = new ErrorConsumer<GetRuleRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetRuleRequest, GetRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetRuleRequest, GetRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetRuleRequest> onError = handler == null ? null : new ErrorConsumer<GetRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRulesResponse> listRules(ListRulesRequest request, AsyncHandler<ListRulesRequest, ListRulesResponse> handler) {
        LOG.trace("Called async listRules");
        final ListRulesRequest interceptedRequest = ListRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRulesResponse> transformer = ListRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRulesRequest, ListRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRulesRequest, ListRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRulesRequest, ListRulesResponse> onSuccess = new SuccessConsumer<ListRulesRequest, ListRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRulesRequest> onError = new ErrorConsumer<ListRulesRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRulesRequest, ListRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRulesRequest, ListRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateRuleResponse> updateRule(UpdateRuleRequest request, AsyncHandler<UpdateRuleRequest, UpdateRuleResponse> handler) {
        LOG.trace("Called async updateRule");
        final UpdateRuleRequest interceptedRequest = UpdateRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateRuleResponse> transformer = UpdateRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateRuleRequest, UpdateRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateRuleRequest, UpdateRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateRuleRequest, UpdateRuleResponse> onSuccess = new SuccessConsumer<UpdateRuleRequest, UpdateRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateRuleRequest> onError = new ErrorConsumer<UpdateRuleRequest>(this, interceptedRequest);
                    EventsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateRuleRequest, UpdateRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateRuleRequest, UpdateRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateRuleRequest> onError = handler == null ? null : new ErrorConsumer<UpdateRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return EventsAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateRuleResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public EventsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new EventsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

