/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.events.Events;
import com.oracle.bmc.events.EventsPaginators;
import com.oracle.bmc.events.EventsWaiters;
import com.oracle.bmc.events.internal.http.ChangeRuleCompartmentConverter;
import com.oracle.bmc.events.internal.http.CreateRuleConverter;
import com.oracle.bmc.events.internal.http.DeleteRuleConverter;
import com.oracle.bmc.events.internal.http.GetRuleConverter;
import com.oracle.bmc.events.internal.http.ListRulesConverter;
import com.oracle.bmc.events.internal.http.UpdateRuleConverter;
import com.oracle.bmc.events.requests.ChangeRuleCompartmentRequest;
import com.oracle.bmc.events.requests.CreateRuleRequest;
import com.oracle.bmc.events.requests.DeleteRuleRequest;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.requests.UpdateRuleRequest;
import com.oracle.bmc.events.responses.ChangeRuleCompartmentResponse;
import com.oracle.bmc.events.responses.CreateRuleResponse;
import com.oracle.bmc.events.responses.DeleteRuleResponse;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.events.responses.UpdateRuleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsClient
implements Events {
    private static final Logger LOG = LoggerFactory.getLogger(EventsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://events.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final EventsWaiters waiters;
    private final EventsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Events-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new EventsWaiters(executorService, this);
        this.paginators = new EventsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeRuleCompartmentResponse changeRuleCompartment(ChangeRuleCompartmentRequest request) {
        LOG.trace("Called changeRuleCompartment");
        ChangeRuleCompartmentRequest interceptedRequest = ChangeRuleCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRuleCompartmentResponse> transformer = ChangeRuleCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeRuleCompartmentDetails(), retriedRequest);
                return (ChangeRuleCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRuleResponse createRule(CreateRuleRequest request) {
        LOG.trace("Called createRule");
        CreateRuleRequest interceptedRequest = CreateRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRuleResponse> transformer = CreateRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateRuleDetails(), retriedRequest);
                return (CreateRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest request) {
        LOG.trace("Called deleteRule");
        DeleteRuleRequest interceptedRequest = DeleteRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRuleResponse> transformer = DeleteRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRuleResponse getRule(GetRuleRequest request) {
        LOG.trace("Called getRule");
        GetRuleRequest interceptedRequest = GetRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRuleResponse> transformer = GetRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest request) {
        LOG.trace("Called listRules");
        ListRulesRequest interceptedRequest = ListRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRulesResponse> transformer = ListRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRuleResponse updateRule(UpdateRuleRequest request) {
        LOG.trace("Called updateRule");
        UpdateRuleRequest interceptedRequest = UpdateRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRuleResponse> transformer = UpdateRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateRuleDetails(), retriedRequest);
                return (UpdateRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EventsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public EventsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public EventsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new EventsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

