/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.events.Events;
import com.oracle.bmc.events.model.RuleSummary;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class EventsPaginators {
    private final Events client;

    public Iterable<ListRulesResponse> listRulesResponseIterator(final ListRulesRequest request) {
        return new ResponseIterable<ListRulesRequest.Builder, ListRulesRequest, ListRulesResponse>(new Supplier<ListRulesRequest.Builder>(){

            public ListRulesRequest.Builder get() {
                return ListRulesRequest.builder().copy(request);
            }
        }, new Function<ListRulesResponse, String>(){

            public String apply(ListRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRulesRequest.Builder>, ListRulesRequest>(){

            public ListRulesRequest apply(RequestBuilderAndToken<ListRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRulesRequest, ListRulesResponse>(){

            public ListRulesResponse apply(ListRulesRequest request) {
                return EventsPaginators.this.client.listRules(request);
            }
        });
    }

    public Iterable<RuleSummary> listRulesRecordIterator(final ListRulesRequest request) {
        return new ResponseRecordIterable<ListRulesRequest.Builder, ListRulesRequest, ListRulesResponse, RuleSummary>(new Supplier<ListRulesRequest.Builder>(){

            public ListRulesRequest.Builder get() {
                return ListRulesRequest.builder().copy(request);
            }
        }, new Function<ListRulesResponse, String>(){

            public String apply(ListRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRulesRequest.Builder>, ListRulesRequest>(){

            public ListRulesRequest apply(RequestBuilderAndToken<ListRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRulesRequest, ListRulesResponse>(){

            public ListRulesResponse apply(ListRulesRequest request) {
                return EventsPaginators.this.client.listRules(request);
            }
        }, new Function<ListRulesResponse, List<RuleSummary>>(){

            public List<RuleSummary> apply(ListRulesResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public EventsPaginators(Events client) {
        this.client = client;
    }
}

