/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.requests;

import com.oracle.bmc.events.model.CreateRuleDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateRuleRequest
extends BmcRequest {
    private CreateRuleDetails createRuleDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"createRuleDetails", "opcRetryToken", "opcRequestId"})
    CreateRuleRequest(CreateRuleDetails createRuleDetails, String opcRetryToken, String opcRequestId) {
        this.createRuleDetails = createRuleDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateRuleDetails getCreateRuleDetails() {
        return this.createRuleDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateRuleDetails createRuleDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateRuleRequest o) {
            this.createRuleDetails(o.getCreateRuleDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateRuleRequest build() {
            CreateRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createRuleDetails(CreateRuleDetails createRuleDetails) {
            this.createRuleDetails = createRuleDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateRuleRequest buildWithoutInvocationCallback() {
            return new CreateRuleRequest(this.createRuleDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateRuleRequest.Builder(createRuleDetails=" + this.createRuleDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

