/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.filestorage.FileStorageAsync;
import com.oracle.bmc.filestorage.internal.http.ChangeFileSystemCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.ChangeMountTargetCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.CreateExportConverter;
import com.oracle.bmc.filestorage.internal.http.CreateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.CreateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.CreateSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteExportConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.GetFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.GetMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.GetSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportSetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportsConverter;
import com.oracle.bmc.filestorage.internal.http.ListFileSystemsConverter;
import com.oracle.bmc.filestorage.internal.http.ListMountTargetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListSnapshotsConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateSnapshotConverter;
import com.oracle.bmc.filestorage.requests.ChangeFileSystemCompartmentRequest;
import com.oracle.bmc.filestorage.requests.ChangeMountTargetCompartmentRequest;
import com.oracle.bmc.filestorage.requests.CreateExportRequest;
import com.oracle.bmc.filestorage.requests.CreateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.CreateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.CreateSnapshotRequest;
import com.oracle.bmc.filestorage.requests.DeleteExportRequest;
import com.oracle.bmc.filestorage.requests.DeleteFileSystemRequest;
import com.oracle.bmc.filestorage.requests.DeleteMountTargetRequest;
import com.oracle.bmc.filestorage.requests.DeleteSnapshotRequest;
import com.oracle.bmc.filestorage.requests.GetExportRequest;
import com.oracle.bmc.filestorage.requests.GetExportSetRequest;
import com.oracle.bmc.filestorage.requests.GetFileSystemRequest;
import com.oracle.bmc.filestorage.requests.GetMountTargetRequest;
import com.oracle.bmc.filestorage.requests.GetSnapshotRequest;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportSetRequest;
import com.oracle.bmc.filestorage.requests.UpdateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.UpdateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.UpdateSnapshotRequest;
import com.oracle.bmc.filestorage.responses.ChangeFileSystemCompartmentResponse;
import com.oracle.bmc.filestorage.responses.ChangeMountTargetCompartmentResponse;
import com.oracle.bmc.filestorage.responses.CreateExportResponse;
import com.oracle.bmc.filestorage.responses.CreateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.CreateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.CreateSnapshotResponse;
import com.oracle.bmc.filestorage.responses.DeleteExportResponse;
import com.oracle.bmc.filestorage.responses.DeleteFileSystemResponse;
import com.oracle.bmc.filestorage.responses.DeleteMountTargetResponse;
import com.oracle.bmc.filestorage.responses.DeleteSnapshotResponse;
import com.oracle.bmc.filestorage.responses.GetExportResponse;
import com.oracle.bmc.filestorage.responses.GetExportSetResponse;
import com.oracle.bmc.filestorage.responses.GetFileSystemResponse;
import com.oracle.bmc.filestorage.responses.GetMountTargetResponse;
import com.oracle.bmc.filestorage.responses.GetSnapshotResponse;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportSetResponse;
import com.oracle.bmc.filestorage.responses.UpdateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.UpdateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.UpdateSnapshotResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageAsyncClient
implements FileStorageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FILESTORAGE").serviceEndpointPrefix("filestorage").serviceEndpointTemplate("https://filestorage.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FileStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FileStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeFileSystemCompartmentResponse> changeFileSystemCompartment(ChangeFileSystemCompartmentRequest request, AsyncHandler<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> handler) {
        LOG.trace("Called async changeFileSystemCompartment");
        final ChangeFileSystemCompartmentRequest interceptedRequest = ChangeFileSystemCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeFileSystemCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeFileSystemCompartmentResponse> transformer = ChangeFileSystemCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> onSuccess = new SuccessConsumer<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeFileSystemCompartmentRequest> onError = new ErrorConsumer<ChangeFileSystemCompartmentRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeFileSystemCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeFileSystemCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeFileSystemCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeFileSystemCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeFileSystemCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeFileSystemCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeFileSystemCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeMountTargetCompartmentResponse> changeMountTargetCompartment(ChangeMountTargetCompartmentRequest request, AsyncHandler<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> handler) {
        LOG.trace("Called async changeMountTargetCompartment");
        final ChangeMountTargetCompartmentRequest interceptedRequest = ChangeMountTargetCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeMountTargetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeMountTargetCompartmentResponse> transformer = ChangeMountTargetCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> onSuccess = new SuccessConsumer<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeMountTargetCompartmentRequest> onError = new ErrorConsumer<ChangeMountTargetCompartmentRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeMountTargetCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeMountTargetCompartmentRequest, ChangeMountTargetCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeMountTargetCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeMountTargetCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeMountTargetCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeMountTargetCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getChangeMountTargetCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeMountTargetCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateExportResponse> createExport(CreateExportRequest request, AsyncHandler<CreateExportRequest, CreateExportResponse> handler) {
        LOG.trace("Called async createExport");
        final CreateExportRequest interceptedRequest = CreateExportConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateExportConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateExportResponse> transformer = CreateExportConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateExportRequest, CreateExportResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateExportRequest, CreateExportResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateExportRequest, CreateExportResponse> onSuccess = new SuccessConsumer<CreateExportRequest, CreateExportResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateExportRequest> onError = new ErrorConsumer<CreateExportRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateExportDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateExportRequest, CreateExportResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateExportRequest, CreateExportResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateExportRequest> onError = handler == null ? null : new ErrorConsumer<CreateExportRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateExportDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateExportResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateExportDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateExportResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateFileSystemResponse> createFileSystem(CreateFileSystemRequest request, AsyncHandler<CreateFileSystemRequest, CreateFileSystemResponse> handler) {
        LOG.trace("Called async createFileSystem");
        final CreateFileSystemRequest interceptedRequest = CreateFileSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateFileSystemResponse> transformer = CreateFileSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateFileSystemRequest, CreateFileSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateFileSystemRequest, CreateFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateFileSystemRequest, CreateFileSystemResponse> onSuccess = new SuccessConsumer<CreateFileSystemRequest, CreateFileSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateFileSystemRequest> onError = new ErrorConsumer<CreateFileSystemRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateFileSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateFileSystemRequest, CreateFileSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateFileSystemRequest, CreateFileSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateFileSystemRequest> onError = handler == null ? null : new ErrorConsumer<CreateFileSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateFileSystemDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateFileSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateFileSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateFileSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateMountTargetResponse> createMountTarget(CreateMountTargetRequest request, AsyncHandler<CreateMountTargetRequest, CreateMountTargetResponse> handler) {
        LOG.trace("Called async createMountTarget");
        final CreateMountTargetRequest interceptedRequest = CreateMountTargetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateMountTargetResponse> transformer = CreateMountTargetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateMountTargetRequest, CreateMountTargetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateMountTargetRequest, CreateMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateMountTargetRequest, CreateMountTargetResponse> onSuccess = new SuccessConsumer<CreateMountTargetRequest, CreateMountTargetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateMountTargetRequest> onError = new ErrorConsumer<CreateMountTargetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateMountTargetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateMountTargetRequest, CreateMountTargetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateMountTargetRequest, CreateMountTargetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateMountTargetRequest> onError = handler == null ? null : new ErrorConsumer<CreateMountTargetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateMountTargetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateMountTargetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateMountTargetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateMountTargetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest request, AsyncHandler<CreateSnapshotRequest, CreateSnapshotResponse> handler) {
        LOG.trace("Called async createSnapshot");
        final CreateSnapshotRequest interceptedRequest = CreateSnapshotConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSnapshotResponse> transformer = CreateSnapshotConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSnapshotRequest, CreateSnapshotResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSnapshotRequest, CreateSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSnapshotRequest, CreateSnapshotResponse> onSuccess = new SuccessConsumer<CreateSnapshotRequest, CreateSnapshotResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSnapshotRequest> onError = new ErrorConsumer<CreateSnapshotRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateSnapshotDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSnapshotRequest, CreateSnapshotResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSnapshotRequest, CreateSnapshotResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSnapshotRequest> onError = handler == null ? null : new ErrorConsumer<CreateSnapshotRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSnapshotDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSnapshotResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateSnapshotDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSnapshotResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteExportResponse> deleteExport(DeleteExportRequest request, AsyncHandler<DeleteExportRequest, DeleteExportResponse> handler) {
        LOG.trace("Called async deleteExport");
        final DeleteExportRequest interceptedRequest = DeleteExportConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteExportConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteExportResponse> transformer = DeleteExportConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteExportRequest, DeleteExportResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteExportRequest, DeleteExportResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteExportRequest, DeleteExportResponse> onSuccess = new SuccessConsumer<DeleteExportRequest, DeleteExportResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteExportRequest> onError = new ErrorConsumer<DeleteExportRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteExportRequest, DeleteExportResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteExportRequest, DeleteExportResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteExportRequest> onError = handler == null ? null : new ErrorConsumer<DeleteExportRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteExportResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteExportResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteFileSystemResponse> deleteFileSystem(DeleteFileSystemRequest request, AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResponse> handler) {
        LOG.trace("Called async deleteFileSystem");
        final DeleteFileSystemRequest interceptedRequest = DeleteFileSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteFileSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteFileSystemResponse> transformer = DeleteFileSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteFileSystemRequest, DeleteFileSystemResponse> onSuccess = new SuccessConsumer<DeleteFileSystemRequest, DeleteFileSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteFileSystemRequest> onError = new ErrorConsumer<DeleteFileSystemRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteFileSystemRequest, DeleteFileSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteFileSystemRequest, DeleteFileSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteFileSystemRequest> onError = handler == null ? null : new ErrorConsumer<DeleteFileSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteFileSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteFileSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteMountTargetResponse> deleteMountTarget(DeleteMountTargetRequest request, AsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResponse> handler) {
        LOG.trace("Called async deleteMountTarget");
        final DeleteMountTargetRequest interceptedRequest = DeleteMountTargetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteMountTargetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteMountTargetResponse> transformer = DeleteMountTargetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteMountTargetRequest, DeleteMountTargetResponse> onSuccess = new SuccessConsumer<DeleteMountTargetRequest, DeleteMountTargetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteMountTargetRequest> onError = new ErrorConsumer<DeleteMountTargetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteMountTargetRequest, DeleteMountTargetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteMountTargetRequest, DeleteMountTargetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteMountTargetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteMountTargetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteMountTargetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteMountTargetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest request, AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResponse> handler) {
        LOG.trace("Called async deleteSnapshot");
        final DeleteSnapshotRequest interceptedRequest = DeleteSnapshotConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSnapshotConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSnapshotResponse> transformer = DeleteSnapshotConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSnapshotRequest, DeleteSnapshotResponse> onSuccess = new SuccessConsumer<DeleteSnapshotRequest, DeleteSnapshotResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSnapshotRequest> onError = new ErrorConsumer<DeleteSnapshotRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSnapshotRequest, DeleteSnapshotResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSnapshotRequest, DeleteSnapshotResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSnapshotRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSnapshotRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSnapshotResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSnapshotResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetExportResponse> getExport(GetExportRequest request, AsyncHandler<GetExportRequest, GetExportResponse> handler) {
        LOG.trace("Called async getExport");
        final GetExportRequest interceptedRequest = GetExportConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetExportConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetExportResponse> transformer = GetExportConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetExportRequest, GetExportResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetExportRequest, GetExportResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetExportRequest, GetExportResponse> onSuccess = new SuccessConsumer<GetExportRequest, GetExportResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetExportRequest> onError = new ErrorConsumer<GetExportRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetExportRequest, GetExportResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetExportRequest, GetExportResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetExportRequest> onError = handler == null ? null : new ErrorConsumer<GetExportRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetExportResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetExportResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetExportSetResponse> getExportSet(GetExportSetRequest request, AsyncHandler<GetExportSetRequest, GetExportSetResponse> handler) {
        LOG.trace("Called async getExportSet");
        final GetExportSetRequest interceptedRequest = GetExportSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetExportSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetExportSetResponse> transformer = GetExportSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetExportSetRequest, GetExportSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetExportSetRequest, GetExportSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetExportSetRequest, GetExportSetResponse> onSuccess = new SuccessConsumer<GetExportSetRequest, GetExportSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetExportSetRequest> onError = new ErrorConsumer<GetExportSetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetExportSetRequest, GetExportSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetExportSetRequest, GetExportSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetExportSetRequest> onError = handler == null ? null : new ErrorConsumer<GetExportSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetExportSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetExportSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetFileSystemResponse> getFileSystem(GetFileSystemRequest request, AsyncHandler<GetFileSystemRequest, GetFileSystemResponse> handler) {
        LOG.trace("Called async getFileSystem");
        final GetFileSystemRequest interceptedRequest = GetFileSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetFileSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetFileSystemResponse> transformer = GetFileSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetFileSystemRequest, GetFileSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetFileSystemRequest, GetFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetFileSystemRequest, GetFileSystemResponse> onSuccess = new SuccessConsumer<GetFileSystemRequest, GetFileSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetFileSystemRequest> onError = new ErrorConsumer<GetFileSystemRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetFileSystemRequest, GetFileSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetFileSystemRequest, GetFileSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetFileSystemRequest> onError = handler == null ? null : new ErrorConsumer<GetFileSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetFileSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetFileSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetMountTargetResponse> getMountTarget(GetMountTargetRequest request, AsyncHandler<GetMountTargetRequest, GetMountTargetResponse> handler) {
        LOG.trace("Called async getMountTarget");
        final GetMountTargetRequest interceptedRequest = GetMountTargetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetMountTargetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetMountTargetResponse> transformer = GetMountTargetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetMountTargetRequest, GetMountTargetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetMountTargetRequest, GetMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetMountTargetRequest, GetMountTargetResponse> onSuccess = new SuccessConsumer<GetMountTargetRequest, GetMountTargetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetMountTargetRequest> onError = new ErrorConsumer<GetMountTargetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetMountTargetRequest, GetMountTargetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetMountTargetRequest, GetMountTargetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetMountTargetRequest> onError = handler == null ? null : new ErrorConsumer<GetMountTargetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetMountTargetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetMountTargetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSnapshotResponse> getSnapshot(GetSnapshotRequest request, AsyncHandler<GetSnapshotRequest, GetSnapshotResponse> handler) {
        LOG.trace("Called async getSnapshot");
        final GetSnapshotRequest interceptedRequest = GetSnapshotConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSnapshotConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSnapshotResponse> transformer = GetSnapshotConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSnapshotRequest, GetSnapshotResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSnapshotRequest, GetSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSnapshotRequest, GetSnapshotResponse> onSuccess = new SuccessConsumer<GetSnapshotRequest, GetSnapshotResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSnapshotRequest> onError = new ErrorConsumer<GetSnapshotRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSnapshotRequest, GetSnapshotResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSnapshotRequest, GetSnapshotResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSnapshotRequest> onError = handler == null ? null : new ErrorConsumer<GetSnapshotRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSnapshotResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSnapshotResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListExportSetsResponse> listExportSets(ListExportSetsRequest request, AsyncHandler<ListExportSetsRequest, ListExportSetsResponse> handler) {
        LOG.trace("Called async listExportSets");
        final ListExportSetsRequest interceptedRequest = ListExportSetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListExportSetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListExportSetsResponse> transformer = ListExportSetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListExportSetsRequest, ListExportSetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListExportSetsRequest, ListExportSetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListExportSetsRequest, ListExportSetsResponse> onSuccess = new SuccessConsumer<ListExportSetsRequest, ListExportSetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListExportSetsRequest> onError = new ErrorConsumer<ListExportSetsRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListExportSetsRequest, ListExportSetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListExportSetsRequest, ListExportSetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListExportSetsRequest> onError = handler == null ? null : new ErrorConsumer<ListExportSetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListExportSetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListExportSetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListExportsResponse> listExports(ListExportsRequest request, AsyncHandler<ListExportsRequest, ListExportsResponse> handler) {
        LOG.trace("Called async listExports");
        final ListExportsRequest interceptedRequest = ListExportsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListExportsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListExportsResponse> transformer = ListExportsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListExportsRequest, ListExportsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListExportsRequest, ListExportsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListExportsRequest, ListExportsResponse> onSuccess = new SuccessConsumer<ListExportsRequest, ListExportsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListExportsRequest> onError = new ErrorConsumer<ListExportsRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListExportsRequest, ListExportsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListExportsRequest, ListExportsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListExportsRequest> onError = handler == null ? null : new ErrorConsumer<ListExportsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListExportsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListExportsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListFileSystemsResponse> listFileSystems(ListFileSystemsRequest request, AsyncHandler<ListFileSystemsRequest, ListFileSystemsResponse> handler) {
        LOG.trace("Called async listFileSystems");
        final ListFileSystemsRequest interceptedRequest = ListFileSystemsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListFileSystemsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListFileSystemsResponse> transformer = ListFileSystemsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListFileSystemsRequest, ListFileSystemsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListFileSystemsRequest, ListFileSystemsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListFileSystemsRequest, ListFileSystemsResponse> onSuccess = new SuccessConsumer<ListFileSystemsRequest, ListFileSystemsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListFileSystemsRequest> onError = new ErrorConsumer<ListFileSystemsRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListFileSystemsRequest, ListFileSystemsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListFileSystemsRequest, ListFileSystemsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListFileSystemsRequest> onError = handler == null ? null : new ErrorConsumer<ListFileSystemsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListFileSystemsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListFileSystemsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMountTargetsResponse> listMountTargets(ListMountTargetsRequest request, AsyncHandler<ListMountTargetsRequest, ListMountTargetsResponse> handler) {
        LOG.trace("Called async listMountTargets");
        final ListMountTargetsRequest interceptedRequest = ListMountTargetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMountTargetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMountTargetsResponse> transformer = ListMountTargetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMountTargetsRequest, ListMountTargetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMountTargetsRequest, ListMountTargetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMountTargetsRequest, ListMountTargetsResponse> onSuccess = new SuccessConsumer<ListMountTargetsRequest, ListMountTargetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMountTargetsRequest> onError = new ErrorConsumer<ListMountTargetsRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMountTargetsRequest, ListMountTargetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMountTargetsRequest, ListMountTargetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMountTargetsRequest> onError = handler == null ? null : new ErrorConsumer<ListMountTargetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMountTargetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMountTargetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest request, AsyncHandler<ListSnapshotsRequest, ListSnapshotsResponse> handler) {
        LOG.trace("Called async listSnapshots");
        final ListSnapshotsRequest interceptedRequest = ListSnapshotsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSnapshotsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSnapshotsResponse> transformer = ListSnapshotsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSnapshotsRequest, ListSnapshotsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSnapshotsRequest, ListSnapshotsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSnapshotsRequest, ListSnapshotsResponse> onSuccess = new SuccessConsumer<ListSnapshotsRequest, ListSnapshotsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSnapshotsRequest> onError = new ErrorConsumer<ListSnapshotsRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSnapshotsRequest, ListSnapshotsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSnapshotsRequest, ListSnapshotsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSnapshotsRequest> onError = handler == null ? null : new ErrorConsumer<ListSnapshotsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSnapshotsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSnapshotsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateExportResponse> updateExport(UpdateExportRequest request, AsyncHandler<UpdateExportRequest, UpdateExportResponse> handler) {
        LOG.trace("Called async updateExport");
        final UpdateExportRequest interceptedRequest = UpdateExportConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateExportConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateExportResponse> transformer = UpdateExportConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateExportRequest, UpdateExportResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateExportRequest, UpdateExportResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateExportRequest, UpdateExportResponse> onSuccess = new SuccessConsumer<UpdateExportRequest, UpdateExportResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateExportRequest> onError = new ErrorConsumer<UpdateExportRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExportDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateExportRequest, UpdateExportResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateExportRequest, UpdateExportResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateExportRequest> onError = handler == null ? null : new ErrorConsumer<UpdateExportRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateExportDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateExportResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExportDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateExportResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateExportSetResponse> updateExportSet(UpdateExportSetRequest request, AsyncHandler<UpdateExportSetRequest, UpdateExportSetResponse> handler) {
        LOG.trace("Called async updateExportSet");
        final UpdateExportSetRequest interceptedRequest = UpdateExportSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateExportSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateExportSetResponse> transformer = UpdateExportSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateExportSetRequest, UpdateExportSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateExportSetRequest, UpdateExportSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateExportSetRequest, UpdateExportSetResponse> onSuccess = new SuccessConsumer<UpdateExportSetRequest, UpdateExportSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateExportSetRequest> onError = new ErrorConsumer<UpdateExportSetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExportSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateExportSetRequest, UpdateExportSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateExportSetRequest, UpdateExportSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateExportSetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateExportSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateExportSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateExportSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExportSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateExportSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateFileSystemResponse> updateFileSystem(UpdateFileSystemRequest request, AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResponse> handler) {
        LOG.trace("Called async updateFileSystem");
        final UpdateFileSystemRequest interceptedRequest = UpdateFileSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateFileSystemResponse> transformer = UpdateFileSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateFileSystemRequest, UpdateFileSystemResponse> onSuccess = new SuccessConsumer<UpdateFileSystemRequest, UpdateFileSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateFileSystemRequest> onError = new ErrorConsumer<UpdateFileSystemRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateFileSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateFileSystemRequest, UpdateFileSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateFileSystemRequest, UpdateFileSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateFileSystemRequest> onError = handler == null ? null : new ErrorConsumer<UpdateFileSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateFileSystemDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateFileSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateFileSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateFileSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateMountTargetResponse> updateMountTarget(UpdateMountTargetRequest request, AsyncHandler<UpdateMountTargetRequest, UpdateMountTargetResponse> handler) {
        LOG.trace("Called async updateMountTarget");
        final UpdateMountTargetRequest interceptedRequest = UpdateMountTargetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateMountTargetResponse> transformer = UpdateMountTargetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateMountTargetRequest, UpdateMountTargetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateMountTargetRequest, UpdateMountTargetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateMountTargetRequest, UpdateMountTargetResponse> onSuccess = new SuccessConsumer<UpdateMountTargetRequest, UpdateMountTargetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateMountTargetRequest> onError = new ErrorConsumer<UpdateMountTargetRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateMountTargetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateMountTargetRequest, UpdateMountTargetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateMountTargetRequest, UpdateMountTargetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateMountTargetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateMountTargetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateMountTargetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateMountTargetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateMountTargetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateMountTargetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest request, AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResponse> handler) {
        LOG.trace("Called async updateSnapshot");
        final UpdateSnapshotRequest interceptedRequest = UpdateSnapshotConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSnapshotResponse> transformer = UpdateSnapshotConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSnapshotRequest, UpdateSnapshotResponse> onSuccess = new SuccessConsumer<UpdateSnapshotRequest, UpdateSnapshotResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSnapshotRequest> onError = new ErrorConsumer<UpdateSnapshotRequest>(this, interceptedRequest);
                    FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSnapshotDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSnapshotRequest, UpdateSnapshotResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSnapshotRequest, UpdateSnapshotResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSnapshotRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSnapshotRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSnapshotDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSnapshotResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return FileStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSnapshotDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSnapshotResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FileStorageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public FileStorageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new FileStorageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

