/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.filestorage.FileStorage;
import com.oracle.bmc.filestorage.FileStoragePaginators;
import com.oracle.bmc.filestorage.FileStorageWaiters;
import com.oracle.bmc.filestorage.internal.http.ChangeFileSystemCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.ChangeMountTargetCompartmentConverter;
import com.oracle.bmc.filestorage.internal.http.CreateExportConverter;
import com.oracle.bmc.filestorage.internal.http.CreateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.CreateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.CreateSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteExportConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.DeleteSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportConverter;
import com.oracle.bmc.filestorage.internal.http.GetExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.GetFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.GetMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.GetSnapshotConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportSetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListExportsConverter;
import com.oracle.bmc.filestorage.internal.http.ListFileSystemsConverter;
import com.oracle.bmc.filestorage.internal.http.ListMountTargetsConverter;
import com.oracle.bmc.filestorage.internal.http.ListSnapshotsConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateExportSetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateFileSystemConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateMountTargetConverter;
import com.oracle.bmc.filestorage.internal.http.UpdateSnapshotConverter;
import com.oracle.bmc.filestorage.requests.ChangeFileSystemCompartmentRequest;
import com.oracle.bmc.filestorage.requests.ChangeMountTargetCompartmentRequest;
import com.oracle.bmc.filestorage.requests.CreateExportRequest;
import com.oracle.bmc.filestorage.requests.CreateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.CreateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.CreateSnapshotRequest;
import com.oracle.bmc.filestorage.requests.DeleteExportRequest;
import com.oracle.bmc.filestorage.requests.DeleteFileSystemRequest;
import com.oracle.bmc.filestorage.requests.DeleteMountTargetRequest;
import com.oracle.bmc.filestorage.requests.DeleteSnapshotRequest;
import com.oracle.bmc.filestorage.requests.GetExportRequest;
import com.oracle.bmc.filestorage.requests.GetExportSetRequest;
import com.oracle.bmc.filestorage.requests.GetFileSystemRequest;
import com.oracle.bmc.filestorage.requests.GetMountTargetRequest;
import com.oracle.bmc.filestorage.requests.GetSnapshotRequest;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportSetRequest;
import com.oracle.bmc.filestorage.requests.UpdateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.UpdateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.UpdateSnapshotRequest;
import com.oracle.bmc.filestorage.responses.ChangeFileSystemCompartmentResponse;
import com.oracle.bmc.filestorage.responses.ChangeMountTargetCompartmentResponse;
import com.oracle.bmc.filestorage.responses.CreateExportResponse;
import com.oracle.bmc.filestorage.responses.CreateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.CreateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.CreateSnapshotResponse;
import com.oracle.bmc.filestorage.responses.DeleteExportResponse;
import com.oracle.bmc.filestorage.responses.DeleteFileSystemResponse;
import com.oracle.bmc.filestorage.responses.DeleteMountTargetResponse;
import com.oracle.bmc.filestorage.responses.DeleteSnapshotResponse;
import com.oracle.bmc.filestorage.responses.GetExportResponse;
import com.oracle.bmc.filestorage.responses.GetExportSetResponse;
import com.oracle.bmc.filestorage.responses.GetFileSystemResponse;
import com.oracle.bmc.filestorage.responses.GetMountTargetResponse;
import com.oracle.bmc.filestorage.responses.GetSnapshotResponse;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportSetResponse;
import com.oracle.bmc.filestorage.responses.UpdateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.UpdateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.UpdateSnapshotResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageClient
implements FileStorage {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FILESTORAGE").serviceEndpointPrefix("filestorage").serviceEndpointTemplate("https://filestorage.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final FileStorageWaiters waiters;
    private final FileStoragePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FileStorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FileStorageWaiters(executorService, this);
        this.paginators = new FileStoragePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeFileSystemCompartmentResponse changeFileSystemCompartment(ChangeFileSystemCompartmentRequest request) {
        LOG.trace("Called changeFileSystemCompartment");
        ChangeFileSystemCompartmentRequest interceptedRequest = ChangeFileSystemCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeFileSystemCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeFileSystemCompartmentResponse> transformer = ChangeFileSystemCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeFileSystemCompartmentDetails(), retriedRequest);
                return (ChangeFileSystemCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeMountTargetCompartmentResponse changeMountTargetCompartment(ChangeMountTargetCompartmentRequest request) {
        LOG.trace("Called changeMountTargetCompartment");
        ChangeMountTargetCompartmentRequest interceptedRequest = ChangeMountTargetCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeMountTargetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeMountTargetCompartmentResponse> transformer = ChangeMountTargetCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeMountTargetCompartmentDetails(), retriedRequest);
                return (ChangeMountTargetCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateExportResponse createExport(CreateExportRequest request) {
        LOG.trace("Called createExport");
        CreateExportRequest interceptedRequest = CreateExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExportResponse> transformer = CreateExportConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateExportDetails(), retriedRequest);
                return (CreateExportResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest request) {
        LOG.trace("Called createFileSystem");
        CreateFileSystemRequest interceptedRequest = CreateFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFileSystemResponse> transformer = CreateFileSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateFileSystemDetails(), retriedRequest);
                return (CreateFileSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest request) {
        LOG.trace("Called createMountTarget");
        CreateMountTargetRequest interceptedRequest = CreateMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMountTargetResponse> transformer = CreateMountTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateMountTargetDetails(), retriedRequest);
                return (CreateMountTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) {
        LOG.trace("Called createSnapshot");
        CreateSnapshotRequest interceptedRequest = CreateSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSnapshotResponse> transformer = CreateSnapshotConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateSnapshotDetails(), retriedRequest);
                return (CreateSnapshotResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest request) {
        LOG.trace("Called deleteExport");
        DeleteExportRequest interceptedRequest = DeleteExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteExportResponse> transformer = DeleteExportConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteExportResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest request) {
        LOG.trace("Called deleteFileSystem");
        DeleteFileSystemRequest interceptedRequest = DeleteFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFileSystemResponse> transformer = DeleteFileSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteFileSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest request) {
        LOG.trace("Called deleteMountTarget");
        DeleteMountTargetRequest interceptedRequest = DeleteMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMountTargetResponse> transformer = DeleteMountTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteMountTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest request) {
        LOG.trace("Called deleteSnapshot");
        DeleteSnapshotRequest interceptedRequest = DeleteSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSnapshotResponse> transformer = DeleteSnapshotConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteSnapshotResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExportResponse getExport(GetExportRequest request) {
        LOG.trace("Called getExport");
        GetExportRequest interceptedRequest = GetExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExportResponse> transformer = GetExportConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetExportResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExportSetResponse getExportSet(GetExportSetRequest request) {
        LOG.trace("Called getExportSet");
        GetExportSetRequest interceptedRequest = GetExportSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExportSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExportSetResponse> transformer = GetExportSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetExportSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFileSystemResponse getFileSystem(GetFileSystemRequest request) {
        LOG.trace("Called getFileSystem");
        GetFileSystemRequest interceptedRequest = GetFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFileSystemResponse> transformer = GetFileSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetFileSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMountTargetResponse getMountTarget(GetMountTargetRequest request) {
        LOG.trace("Called getMountTarget");
        GetMountTargetRequest interceptedRequest = GetMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMountTargetResponse> transformer = GetMountTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetMountTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSnapshotResponse getSnapshot(GetSnapshotRequest request) {
        LOG.trace("Called getSnapshot");
        GetSnapshotRequest interceptedRequest = GetSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSnapshotResponse> transformer = GetSnapshotConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetSnapshotResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListExportSetsResponse listExportSets(ListExportSetsRequest request) {
        LOG.trace("Called listExportSets");
        ListExportSetsRequest interceptedRequest = ListExportSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExportSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExportSetsResponse> transformer = ListExportSetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListExportSetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListExportsResponse listExports(ListExportsRequest request) {
        LOG.trace("Called listExports");
        ListExportsRequest interceptedRequest = ListExportsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExportsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExportsResponse> transformer = ListExportsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListExportsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFileSystemsResponse listFileSystems(ListFileSystemsRequest request) {
        LOG.trace("Called listFileSystems");
        ListFileSystemsRequest interceptedRequest = ListFileSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFileSystemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFileSystemsResponse> transformer = ListFileSystemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListFileSystemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMountTargetsResponse listMountTargets(ListMountTargetsRequest request) {
        LOG.trace("Called listMountTargets");
        ListMountTargetsRequest interceptedRequest = ListMountTargetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMountTargetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMountTargetsResponse> transformer = ListMountTargetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListMountTargetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest request) {
        LOG.trace("Called listSnapshots");
        ListSnapshotsRequest interceptedRequest = ListSnapshotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSnapshotsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSnapshotsResponse> transformer = ListSnapshotsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListSnapshotsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest request) {
        LOG.trace("Called updateExport");
        UpdateExportRequest interceptedRequest = UpdateExportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExportConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExportResponse> transformer = UpdateExportConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateExportDetails(), retriedRequest);
                return (UpdateExportResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateExportSetResponse updateExportSet(UpdateExportSetRequest request) {
        LOG.trace("Called updateExportSet");
        UpdateExportSetRequest interceptedRequest = UpdateExportSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExportSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExportSetResponse> transformer = UpdateExportSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateExportSetDetails(), retriedRequest);
                return (UpdateExportSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest request) {
        LOG.trace("Called updateFileSystem");
        UpdateFileSystemRequest interceptedRequest = UpdateFileSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFileSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFileSystemResponse> transformer = UpdateFileSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateFileSystemDetails(), retriedRequest);
                return (UpdateFileSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateMountTargetResponse updateMountTarget(UpdateMountTargetRequest request) {
        LOG.trace("Called updateMountTarget");
        UpdateMountTargetRequest interceptedRequest = UpdateMountTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMountTargetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMountTargetResponse> transformer = UpdateMountTargetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateMountTargetDetails(), retriedRequest);
                return (UpdateMountTargetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest request) {
        LOG.trace("Called updateSnapshot");
        UpdateSnapshotRequest interceptedRequest = UpdateSnapshotConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSnapshotConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSnapshotResponse> transformer = UpdateSnapshotConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateSnapshotDetails(), retriedRequest);
                return (UpdateSnapshotResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public FileStorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FileStoragePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FileStorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public FileStorageClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new FileStorageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

