/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.filestorage.model.MountTarget;
import com.oracle.bmc.filestorage.requests.UpdateMountTargetRequest;
import com.oracle.bmc.filestorage.responses.UpdateMountTargetResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMountTargetConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMountTargetConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateMountTargetRequest interceptRequest(UpdateMountTargetRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateMountTargetRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMountTargetId(), (String)"mountTargetId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateMountTargetDetails(), (String)"updateMountTargetDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20171215").path("mountTargets").path(HttpUtils.encodePathSegment(request.getMountTargetId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateMountTargetResponse> fromResponse() {
        Function<Response, UpdateMountTargetResponse> transformer = new Function<Response, UpdateMountTargetResponse>(){

            public UpdateMountTargetResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateMountTargetResponse");
                Function<Response, WithHeaders<MountTarget>> responseFn = RESPONSE_CONVERSION_FACTORY.create(MountTarget.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateMountTargetResponse.Builder builder = UpdateMountTargetResponse.builder();
                builder.mountTarget((MountTarget)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateMountTargetResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

