/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClientOptions {
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="requirePrivilegedSourcePort")
    private final Boolean requirePrivilegedSourcePort;
    @JsonProperty(value="access")
    private final Access access;
    @JsonProperty(value="identitySquash")
    private final IdentitySquash identitySquash;
    @JsonProperty(value="anonymousUid")
    private final Long anonymousUid;
    @JsonProperty(value="anonymousGid")
    private final Long anonymousGid;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getRequirePrivilegedSourcePort() {
        return this.requirePrivilegedSourcePort;
    }

    public Access getAccess() {
        return this.access;
    }

    public IdentitySquash getIdentitySquash() {
        return this.identitySquash;
    }

    public Long getAnonymousUid() {
        return this.anonymousUid;
    }

    public Long getAnonymousGid() {
        return this.anonymousGid;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientOptions)) {
            return false;
        }
        ClientOptions other = (ClientOptions)o;
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Boolean this$requirePrivilegedSourcePort = this.getRequirePrivilegedSourcePort();
        Boolean other$requirePrivilegedSourcePort = other.getRequirePrivilegedSourcePort();
        if (this$requirePrivilegedSourcePort == null ? other$requirePrivilegedSourcePort != null : !((Object)this$requirePrivilegedSourcePort).equals(other$requirePrivilegedSourcePort)) {
            return false;
        }
        Access this$access = this.getAccess();
        Access other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)((Object)this$access)).equals((Object)other$access)) {
            return false;
        }
        IdentitySquash this$identitySquash = this.getIdentitySquash();
        IdentitySquash other$identitySquash = other.getIdentitySquash();
        if (this$identitySquash == null ? other$identitySquash != null : !((Object)((Object)this$identitySquash)).equals((Object)other$identitySquash)) {
            return false;
        }
        Long this$anonymousUid = this.getAnonymousUid();
        Long other$anonymousUid = other.getAnonymousUid();
        if (this$anonymousUid == null ? other$anonymousUid != null : !((Object)this$anonymousUid).equals(other$anonymousUid)) {
            return false;
        }
        Long this$anonymousGid = this.getAnonymousGid();
        Long other$anonymousGid = other.getAnonymousGid();
        if (this$anonymousGid == null ? other$anonymousGid != null : !((Object)this$anonymousGid).equals(other$anonymousGid)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Boolean $requirePrivilegedSourcePort = this.getRequirePrivilegedSourcePort();
        result = result * 59 + ($requirePrivilegedSourcePort == null ? 43 : ((Object)$requirePrivilegedSourcePort).hashCode());
        Access $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)((Object)$access)).hashCode());
        IdentitySquash $identitySquash = this.getIdentitySquash();
        result = result * 59 + ($identitySquash == null ? 43 : ((Object)((Object)$identitySquash)).hashCode());
        Long $anonymousUid = this.getAnonymousUid();
        result = result * 59 + ($anonymousUid == null ? 43 : ((Object)$anonymousUid).hashCode());
        Long $anonymousGid = this.getAnonymousGid();
        result = result * 59 + ($anonymousGid == null ? 43 : ((Object)$anonymousGid).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "ClientOptions(source=" + this.getSource() + ", requirePrivilegedSourcePort=" + this.getRequirePrivilegedSourcePort() + ", access=" + (Object)((Object)this.getAccess()) + ", identitySquash=" + (Object)((Object)this.getIdentitySquash()) + ", anonymousUid=" + this.getAnonymousUid() + ", anonymousGid=" + this.getAnonymousGid() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"source", "requirePrivilegedSourcePort", "access", "identitySquash", "anonymousUid", "anonymousGid"})
    @Deprecated
    public ClientOptions(String source, Boolean requirePrivilegedSourcePort, Access access, IdentitySquash identitySquash, Long anonymousUid, Long anonymousGid) {
        this.source = source;
        this.requirePrivilegedSourcePort = requirePrivilegedSourcePort;
        this.access = access;
        this.identitySquash = identitySquash;
        this.anonymousUid = anonymousUid;
        this.anonymousGid = anonymousGid;
    }

    public static enum IdentitySquash {
        None("NONE"),
        Root("ROOT"),
        All("ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IdentitySquash> map;

        private IdentitySquash(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IdentitySquash create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IdentitySquash', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IdentitySquash.class);
            map = new HashMap<String, IdentitySquash>();
            for (IdentitySquash v : IdentitySquash.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Access {
        ReadWrite("READ_WRITE"),
        ReadOnly("READ_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Access> map;

        private Access(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Access create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Access', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Access.class);
            map = new HashMap<String, Access>();
            for (Access v : Access.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="requirePrivilegedSourcePort")
        private Boolean requirePrivilegedSourcePort;
        @JsonProperty(value="access")
        private Access access;
        @JsonProperty(value="identitySquash")
        private IdentitySquash identitySquash;
        @JsonProperty(value="anonymousUid")
        private Long anonymousUid;
        @JsonProperty(value="anonymousGid")
        private Long anonymousGid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder requirePrivilegedSourcePort(Boolean requirePrivilegedSourcePort) {
            this.requirePrivilegedSourcePort = requirePrivilegedSourcePort;
            this.__explicitlySet__.add("requirePrivilegedSourcePort");
            return this;
        }

        public Builder access(Access access) {
            this.access = access;
            this.__explicitlySet__.add("access");
            return this;
        }

        public Builder identitySquash(IdentitySquash identitySquash) {
            this.identitySquash = identitySquash;
            this.__explicitlySet__.add("identitySquash");
            return this;
        }

        public Builder anonymousUid(Long anonymousUid) {
            this.anonymousUid = anonymousUid;
            this.__explicitlySet__.add("anonymousUid");
            return this;
        }

        public Builder anonymousGid(Long anonymousGid) {
            this.anonymousGid = anonymousGid;
            this.__explicitlySet__.add("anonymousGid");
            return this;
        }

        public ClientOptions build() {
            ClientOptions __instance__ = new ClientOptions(this.source, this.requirePrivilegedSourcePort, this.access, this.identitySquash, this.anonymousUid, this.anonymousGid);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ClientOptions o) {
            Builder copiedBuilder = this.source(o.getSource()).requirePrivilegedSourcePort(o.getRequirePrivilegedSourcePort()).access(o.getAccess()).identitySquash(o.getIdentitySquash()).anonymousUid(o.getAnonymousUid()).anonymousGid(o.getAnonymousGid());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

