/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.filestorage.model.CreateFileSystemDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateFileSystemRequest
extends BmcRequest {
    private CreateFileSystemDetails createFileSystemDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"createFileSystemDetails", "opcRetryToken", "opcRequestId"})
    CreateFileSystemRequest(CreateFileSystemDetails createFileSystemDetails, String opcRetryToken, String opcRequestId) {
        this.createFileSystemDetails = createFileSystemDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateFileSystemDetails getCreateFileSystemDetails() {
        return this.createFileSystemDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateFileSystemDetails createFileSystemDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateFileSystemRequest o) {
            this.createFileSystemDetails(o.getCreateFileSystemDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateFileSystemRequest build() {
            CreateFileSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createFileSystemDetails(CreateFileSystemDetails createFileSystemDetails) {
            this.createFileSystemDetails = createFileSystemDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateFileSystemRequest buildWithoutInvocationCallback() {
            return new CreateFileSystemRequest(this.createFileSystemDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateFileSystemRequest.Builder(createFileSystemDetails=" + this.createFileSystemDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

