/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSnapshotRequest
extends BmcRequest {
    private String snapshotId;
    private String opcRequestId;

    @ConstructorProperties(value={"snapshotId", "opcRequestId"})
    GetSnapshotRequest(String snapshotId, String opcRequestId) {
        this.snapshotId = snapshotId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String snapshotId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSnapshotRequest o) {
            this.snapshotId(o.getSnapshotId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSnapshotRequest build() {
            GetSnapshotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSnapshotRequest buildWithoutInvocationCallback() {
            return new GetSnapshotRequest(this.snapshotId, this.opcRequestId);
        }

        public String toString() {
            return "GetSnapshotRequest.Builder(snapshotId=" + this.snapshotId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

