/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.filestorage.model.UpdateExportDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateExportRequest
extends BmcRequest {
    private String exportId;
    private UpdateExportDetails updateExportDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"exportId", "updateExportDetails", "ifMatch", "opcRequestId"})
    UpdateExportRequest(String exportId, UpdateExportDetails updateExportDetails, String ifMatch, String opcRequestId) {
        this.exportId = exportId;
        this.updateExportDetails = updateExportDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExportId() {
        return this.exportId;
    }

    public UpdateExportDetails getUpdateExportDetails() {
        return this.updateExportDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String exportId;
        private UpdateExportDetails updateExportDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExportRequest o) {
            this.exportId(o.getExportId());
            this.updateExportDetails(o.getUpdateExportDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExportRequest build() {
            UpdateExportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public Builder updateExportDetails(UpdateExportDetails updateExportDetails) {
            this.updateExportDetails = updateExportDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateExportRequest buildWithoutInvocationCallback() {
            return new UpdateExportRequest(this.exportId, this.updateExportDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateExportRequest.Builder(exportId=" + this.exportId + ", updateExportDetails=" + this.updateExportDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

