/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.filestorage.model.UpdateExportSetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateExportSetRequest
extends BmcRequest {
    private String exportSetId;
    private UpdateExportSetDetails updateExportSetDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"exportSetId", "updateExportSetDetails", "ifMatch", "opcRequestId"})
    UpdateExportSetRequest(String exportSetId, UpdateExportSetDetails updateExportSetDetails, String ifMatch, String opcRequestId) {
        this.exportSetId = exportSetId;
        this.updateExportSetDetails = updateExportSetDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExportSetId() {
        return this.exportSetId;
    }

    public UpdateExportSetDetails getUpdateExportSetDetails() {
        return this.updateExportSetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String exportSetId;
        private UpdateExportSetDetails updateExportSetDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExportSetRequest o) {
            this.exportSetId(o.getExportSetId());
            this.updateExportSetDetails(o.getUpdateExportSetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExportSetRequest build() {
            UpdateExportSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder exportSetId(String exportSetId) {
            this.exportSetId = exportSetId;
            return this;
        }

        public Builder updateExportSetDetails(UpdateExportSetDetails updateExportSetDetails) {
            this.updateExportSetDetails = updateExportSetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateExportSetRequest buildWithoutInvocationCallback() {
            return new UpdateExportSetRequest(this.exportSetId, this.updateExportSetDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateExportSetRequest.Builder(exportSetId=" + this.exportSetId + ", updateExportSetDetails=" + this.updateExportSetDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

