/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.Export;
import java.beans.ConstructorProperties;

public class CreateExportResponse {
    private String etag;
    private String opcRequestId;
    private Export export;

    @ConstructorProperties(value={"etag", "opcRequestId", "export"})
    CreateExportResponse(String etag, String opcRequestId, Export export) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.export = export;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Export getExport() {
        return this.export;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Export export;

        public Builder copy(CreateExportResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.export(o.getExport());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder export(Export export) {
            this.export = export;
            return this;
        }

        public CreateExportResponse build() {
            return new CreateExportResponse(this.etag, this.opcRequestId, this.export);
        }

        public String toString() {
            return "CreateExportResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", export=" + this.export + ")";
        }
    }
}

