/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.MountTarget;
import java.beans.ConstructorProperties;

public class CreateMountTargetResponse {
    private String etag;
    private String opcRequestId;
    private MountTarget mountTarget;

    @ConstructorProperties(value={"etag", "opcRequestId", "mountTarget"})
    CreateMountTargetResponse(String etag, String opcRequestId, MountTarget mountTarget) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.mountTarget = mountTarget;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MountTarget getMountTarget() {
        return this.mountTarget;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private MountTarget mountTarget;

        public Builder copy(CreateMountTargetResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.mountTarget(o.getMountTarget());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder mountTarget(MountTarget mountTarget) {
            this.mountTarget = mountTarget;
            return this;
        }

        public CreateMountTargetResponse build() {
            return new CreateMountTargetResponse(this.etag, this.opcRequestId, this.mountTarget);
        }

        public String toString() {
            return "CreateMountTargetResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", mountTarget=" + this.mountTarget + ")";
        }
    }
}

