/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.ExportSet;
import java.beans.ConstructorProperties;

public class GetExportSetResponse {
    private String etag;
    private String opcRequestId;
    private ExportSet exportSet;

    @ConstructorProperties(value={"etag", "opcRequestId", "exportSet"})
    GetExportSetResponse(String etag, String opcRequestId, ExportSet exportSet) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.exportSet = exportSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ExportSet getExportSet() {
        return this.exportSet;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ExportSet exportSet;

        public Builder copy(GetExportSetResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.exportSet(o.getExportSet());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder exportSet(ExportSet exportSet) {
            this.exportSet = exportSet;
            return this;
        }

        public GetExportSetResponse build() {
            return new GetExportSetResponse(this.etag, this.opcRequestId, this.exportSet);
        }

        public String toString() {
            return "GetExportSetResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", exportSet=" + this.exportSet + ")";
        }
    }
}

