/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.ExportSetSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListExportSetsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<ExportSetSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListExportSetsResponse(String opcNextPage, String opcRequestId, List<ExportSetSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ExportSetSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<ExportSetSummary> items;

        public Builder copy(ListExportSetsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ExportSetSummary> items) {
            this.items = items;
            return this;
        }

        public ListExportSetsResponse build() {
            return new ListExportSetsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListExportSetsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

