/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.ExportSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListExportsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<ExportSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListExportsResponse(String opcNextPage, String opcRequestId, List<ExportSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ExportSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<ExportSummary> items;

        public Builder copy(ListExportsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ExportSummary> items) {
            this.items = items;
            return this;
        }

        public ListExportsResponse build() {
            return new ListExportsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListExportsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

