/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.FileSystemSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListFileSystemsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<FileSystemSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListFileSystemsResponse(String opcNextPage, String opcRequestId, List<FileSystemSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<FileSystemSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<FileSystemSummary> items;

        public Builder copy(ListFileSystemsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<FileSystemSummary> items) {
            this.items = items;
            return this;
        }

        public ListFileSystemsResponse build() {
            return new ListFileSystemsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListFileSystemsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

