/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.FileSystem;
import java.beans.ConstructorProperties;

public class UpdateFileSystemResponse {
    private String etag;
    private String opcRequestId;
    private FileSystem fileSystem;

    @ConstructorProperties(value={"etag", "opcRequestId", "fileSystem"})
    UpdateFileSystemResponse(String etag, String opcRequestId, FileSystem fileSystem) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.fileSystem = fileSystem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private FileSystem fileSystem;

        public Builder copy(UpdateFileSystemResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.fileSystem(o.getFileSystem());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public UpdateFileSystemResponse build() {
            return new UpdateFileSystemResponse(this.etag, this.opcRequestId, this.fileSystem);
        }

        public String toString() {
            return "UpdateFileSystemResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", fileSystem=" + this.fileSystem + ")";
        }
    }
}

