/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.Snapshot;
import java.beans.ConstructorProperties;

public class UpdateSnapshotResponse {
    private String etag;
    private String opcRequestId;
    private Snapshot snapshot;

    @ConstructorProperties(value={"etag", "opcRequestId", "snapshot"})
    UpdateSnapshotResponse(String etag, String opcRequestId, Snapshot snapshot) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.snapshot = snapshot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Snapshot snapshot;

        public Builder copy(UpdateSnapshotResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.snapshot(o.getSnapshot());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public UpdateSnapshotResponse build() {
            return new UpdateSnapshotResponse(this.etag, this.opcRequestId, this.snapshot);
        }

        public String toString() {
            return "UpdateSnapshotResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", snapshot=" + this.snapshot + ")";
        }
    }
}

